class LuxonError extends Error{}class InvalidDateTimeError extends LuxonError{constructor(e){super(`Invalid DateTime: ${e.toMessage()}`)}}class InvalidIntervalError extends LuxonError{constructor(e){super(`Invalid Interval: ${e.toMessage()}`)}}class InvalidDurationError extends LuxonError{constructor(e){super(`Invalid Duration: ${e.toMessage()}`)}}class ConflictingSpecificationError extends LuxonError{}class InvalidUnitError extends LuxonError{constructor(e){super(`Invalid unit ${e}`)}}class InvalidArgumentError extends LuxonError{}class ZoneIsAbstractError extends LuxonError{constructor(){super("Zone is an abstract class")}}const n="numeric",s="short",l="long",DATE_SHORT={year:n,month:n,day:n},DATE_MED={year:n,month:s,day:n},DATE_MED_WITH_WEEKDAY={year:n,month:s,day:n,weekday:s},DATE_FULL={year:n,month:l,day:n},DATE_HUGE={year:n,month:l,day:n,weekday:l},TIME_SIMPLE={hour:n,minute:n},TIME_WITH_SECONDS={hour:n,minute:n,second:n},TIME_WITH_SHORT_OFFSET={hour:n,minute:n,second:n,timeZoneName:s},TIME_WITH_LONG_OFFSET={hour:n,minute:n,second:n,timeZoneName:l},TIME_24_SIMPLE={hour:n,minute:n,hourCycle:"h23"},TIME_24_WITH_SECONDS={hour:n,minute:n,second:n,hourCycle:"h23"},TIME_24_WITH_SHORT_OFFSET={hour:n,minute:n,second:n,hourCycle:"h23",timeZoneName:s},TIME_24_WITH_LONG_OFFSET={hour:n,minute:n,second:n,hourCycle:"h23",timeZoneName:l},DATETIME_SHORT={year:n,month:n,day:n,hour:n,minute:n},DATETIME_SHORT_WITH_SECONDS={year:n,month:n,day:n,hour:n,minute:n,second:n},DATETIME_MED={year:n,month:s,day:n,hour:n,minute:n},DATETIME_MED_WITH_SECONDS={year:n,month:s,day:n,hour:n,minute:n,second:n},DATETIME_MED_WITH_WEEKDAY={year:n,month:s,day:n,weekday:s,hour:n,minute:n},DATETIME_FULL={year:n,month:l,day:n,hour:n,minute:n,timeZoneName:s},DATETIME_FULL_WITH_SECONDS={year:n,month:l,day:n,hour:n,minute:n,second:n,timeZoneName:s},DATETIME_HUGE={year:n,month:l,day:n,weekday:l,hour:n,minute:n,timeZoneName:l},DATETIME_HUGE_WITH_SECONDS={year:n,month:l,day:n,weekday:l,hour:n,minute:n,second:n,timeZoneName:l};class Zone{get type(){throw new ZoneIsAbstractError}get name(){throw new ZoneIsAbstractError}get ianaName(){return this.name}get isUniversal(){throw new ZoneIsAbstractError}offsetName(e,t){throw new ZoneIsAbstractError}formatOffset(e,t){throw new ZoneIsAbstractError}offset(e){throw new ZoneIsAbstractError}equals(e){throw new ZoneIsAbstractError}get isValid(){throw new ZoneIsAbstractError}}let singleton$1=null;class SystemZone extends Zone{static get instance(){return null===singleton$1&&(singleton$1=new SystemZone),singleton$1}get type(){return"system"}get name(){return(new Intl.DateTimeFormat).resolvedOptions().timeZone}get isUniversal(){return!1}offsetName(e,{format:t,locale:n}){return parseZoneInfo(e,t,n)}formatOffset(e,t){return formatOffset(this.offset(e),t)}offset(e){return-new Date(e).getTimezoneOffset()}equals(e){return"system"===e.type}get isValid(){return!0}}let dtfCache={};function makeDTF(e){return dtfCache[e]||(dtfCache[e]=new Intl.DateTimeFormat("en-US",{hour12:!1,timeZone:e,year:"numeric",month:"2-digit",day:"2-digit",hour:"2-digit",minute:"2-digit",second:"2-digit",era:"short"})),dtfCache[e]}const typeToPos={year:0,month:1,day:2,era:3,hour:4,minute:5,second:6};function hackyOffset(e,t){const n=e.format(t).replace(/\u200E/g,""),r=/(\d+)\/(\d+)\/(\d+) (AD|BC),? (\d+):(\d+):(\d+)/.exec(n),[,i,s,a,o,u,l,c]=r;return[a,i,s,o,u,l,c]}function partsOffset(e,t){const n=e.formatToParts(t),r=[];for(let e=0;e<n.length;e++){const{type:t,value:i}=n[e],s=typeToPos[t];"era"===t?r[s]=i:isUndefined(s)||(r[s]=parseInt(i,10))}return r}let ianaZoneCache={};class IANAZone extends Zone{static create(e){return ianaZoneCache[e]||(ianaZoneCache[e]=new IANAZone(e)),ianaZoneCache[e]}static resetCache(){ianaZoneCache={},dtfCache={}}static isValidSpecifier(e){return this.isValidZone(e)}static isValidZone(e){if(!e)return!1;try{return new Intl.DateTimeFormat("en-US",{timeZone:e}).format(),!0}catch(e){return!1}}constructor(e){super(),this.zoneName=e,this.valid=IANAZone.isValidZone(e)}get type(){return"iana"}get name(){return this.zoneName}get isUniversal(){return!1}offsetName(e,{format:t,locale:n}){return parseZoneInfo(e,t,n,this.name)}formatOffset(e,t){return formatOffset(this.offset(e),t)}offset(e){const t=new Date(e);if(isNaN(t))return NaN;const n=makeDTF(this.name);let[r,i,s,a,o,u,l]=n.formatToParts?partsOffset(n,t):hackyOffset(n,t);"BC"===a&&(r=1-Math.abs(r));let c=+t;const d=c%1e3;return c-=d>=0?d:1e3+d,(objToLocalTS({year:r,month:i,day:s,hour:24===o?0:o,minute:u,second:l,millisecond:0})-c)/6e4}equals(e){return"iana"===e.type&&e.name===this.name}get isValid(){return this.valid}}let intlLFCache={};function getCachedLF(e,t={}){const n=JSON.stringify([e,t]);let r=intlLFCache[n];return r||(r=new Intl.ListFormat(e,t),intlLFCache[n]=r),r}let intlDTCache={};function getCachedDTF(e,t={}){const n=JSON.stringify([e,t]);let r=intlDTCache[n];return r||(r=new Intl.DateTimeFormat(e,t),intlDTCache[n]=r),r}let intlNumCache={};function getCachedINF(e,t={}){const n=JSON.stringify([e,t]);let r=intlNumCache[n];return r||(r=new Intl.NumberFormat(e,t),intlNumCache[n]=r),r}let intlRelCache={};function getCachedRTF(e,t={}){const{base:n,...r}=t,i=JSON.stringify([e,r]);let s=intlRelCache[i];return s||(s=new Intl.RelativeTimeFormat(e,t),intlRelCache[i]=s),s}let sysLocaleCache=null;function systemLocale(){return sysLocaleCache||(sysLocaleCache=(new Intl.DateTimeFormat).resolvedOptions().locale,sysLocaleCache)}let weekInfoCache={};function getCachedWeekInfo(e){let t=weekInfoCache[e];if(!t){const n=new Intl.Locale(e);t="getWeekInfo"in n?n.getWeekInfo():n.weekInfo,weekInfoCache[e]=t}return t}function parseLocaleString(e){const t=e.indexOf("-x-");-1!==t&&(e=e.substring(0,t));const n=e.indexOf("-u-");if(-1===n)return[e];{let t,r;try{t=getCachedDTF(e).resolvedOptions(),r=e}catch(i){const s=e.substring(0,n);t=getCachedDTF(s).resolvedOptions(),r=s}const{numberingSystem:i,calendar:s}=t;return[r,i,s]}}function intlConfigString(e,t,n){return n||t?(e.includes("-u-")||(e+="-u"),n&&(e+=`-ca-${n}`),t&&(e+=`-nu-${t}`),e):e}function mapMonths(e){const t=[];for(let n=1;n<=12;n++){const r=DateTime.utc(2009,n,1);t.push(e(r))}return t}function mapWeekdays(e){const t=[];for(let n=1;n<=7;n++){const r=DateTime.utc(2016,11,13+n);t.push(e(r))}return t}function listStuff(e,t,n,r){const i=e.listingMode();return"error"===i?null:"en"===i?n(t):r(t)}function supportsFastNumbers(e){return(!e.numberingSystem||"latn"===e.numberingSystem)&&("latn"===e.numberingSystem||!e.locale||e.locale.startsWith("en")||"latn"===new Intl.DateTimeFormat(e.intl).resolvedOptions().numberingSystem)}class PolyNumberFormatter{constructor(e,t,n){this.padTo=n.padTo||0,this.floor=n.floor||!1;const{padTo:r,floor:i,...s}=n;if(!t||Object.keys(s).length>0){const t={useGrouping:!1,...n};n.padTo>0&&(t.minimumIntegerDigits=n.padTo),this.inf=getCachedINF(e,t)}}format(e){if(this.inf){const t=this.floor?Math.floor(e):e;return this.inf.format(t)}return padStart(this.floor?Math.floor(e):roundTo(e,3),this.padTo)}}class PolyDateFormatter{constructor(e,t,n){let r;if(this.opts=n,this.originalZone=void 0,this.opts.timeZone)this.dt=e;else if("fixed"===e.zone.type){const t=e.offset/60*-1,n=t>=0?`Etc/GMT+${t}`:`Etc/GMT${t}`;0!==e.offset&&IANAZone.create(n).valid?(r=n,this.dt=e):(r="UTC",this.dt=0===e.offset?e:e.setZone("UTC").plus({minutes:e.offset}),this.originalZone=e.zone)}else"system"===e.zone.type?this.dt=e:"iana"===e.zone.type?(this.dt=e,r=e.zone.name):(r="UTC",this.dt=e.setZone("UTC").plus({minutes:e.offset}),this.originalZone=e.zone);const i={...this.opts};i.timeZone=i.timeZone||r,this.dtf=getCachedDTF(t,i)}format(){return this.originalZone?this.formatToParts().map((({value:e})=>e)).join(""):this.dtf.format(this.dt.toJSDate())}formatToParts(){const e=this.dtf.formatToParts(this.dt.toJSDate());return this.originalZone?e.map((e=>{if("timeZoneName"===e.type){const t=this.originalZone.offsetName(this.dt.ts,{locale:this.dt.locale,format:this.opts.timeZoneName});return{...e,value:t}}return e})):e}resolvedOptions(){return this.dtf.resolvedOptions()}}class PolyRelFormatter{constructor(e,t,n){this.opts={style:"long",...n},!t&&hasRelative()&&(this.rtf=getCachedRTF(e,n))}format(e,t){return this.rtf?this.rtf.format(e,t):formatRelativeTime(t,e,this.opts.numeric,"long"!==this.opts.style)}formatToParts(e,t){return this.rtf?this.rtf.formatToParts(e,t):[]}}const fallbackWeekSettings={firstDay:1,minimalDays:4,weekend:[6,7]};class Locale{static fromOpts(e){return Locale.create(e.locale,e.numberingSystem,e.outputCalendar,e.weekSettings,e.defaultToEN)}static create(e,t,n,r,i=!1){const s=e||Settings.defaultLocale,a=s||(i?"en-US":systemLocale()),o=t||Settings.defaultNumberingSystem,u=n||Settings.defaultOutputCalendar,l=validateWeekSettings(r)||Settings.defaultWeekSettings;return new Locale(a,o,u,l,s)}static resetCache(){sysLocaleCache=null,intlDTCache={},intlNumCache={},intlRelCache={}}static fromObject({locale:e,numberingSystem:t,outputCalendar:n,weekSettings:r}={}){return Locale.create(e,t,n,r)}constructor(e,t,n,r,i){const[s,a,o]=parseLocaleString(e);this.locale=s,this.numberingSystem=t||a||null,this.outputCalendar=n||o||null,this.weekSettings=r,this.intl=intlConfigString(this.locale,this.numberingSystem,this.outputCalendar),this.weekdaysCache={format:{},standalone:{}},this.monthsCache={format:{},standalone:{}},this.meridiemCache=null,this.eraCache={},this.specifiedLocale=i,this.fastNumbersCached=null}get fastNumbers(){return null==this.fastNumbersCached&&(this.fastNumbersCached=supportsFastNumbers(this)),this.fastNumbersCached}listingMode(){const e=this.isEnglish(),t=!(null!==this.numberingSystem&&"latn"!==this.numberingSystem||null!==this.outputCalendar&&"gregory"!==this.outputCalendar);return e&&t?"en":"intl"}clone(e){return e&&0!==Object.getOwnPropertyNames(e).length?Locale.create(e.locale||this.specifiedLocale,e.numberingSystem||this.numberingSystem,e.outputCalendar||this.outputCalendar,validateWeekSettings(e.weekSettings)||this.weekSettings,e.defaultToEN||!1):this}redefaultToEN(e={}){return this.clone({...e,defaultToEN:!0})}redefaultToSystem(e={}){return this.clone({...e,defaultToEN:!1})}months(e,t=!1){return listStuff(this,e,months,(()=>{const n=t?{month:e,day:"numeric"}:{month:e},r=t?"format":"standalone";return this.monthsCache[r][e]||(this.monthsCache[r][e]=mapMonths((e=>this.extract(e,n,"month")))),this.monthsCache[r][e]}))}weekdays(e,t=!1){return listStuff(this,e,weekdays,(()=>{const n=t?{weekday:e,year:"numeric",month:"long",day:"numeric"}:{weekday:e},r=t?"format":"standalone";return this.weekdaysCache[r][e]||(this.weekdaysCache[r][e]=mapWeekdays((e=>this.extract(e,n,"weekday")))),this.weekdaysCache[r][e]}))}meridiems(){return listStuff(this,void 0,(()=>meridiems),(()=>{if(!this.meridiemCache){const e={hour:"numeric",hourCycle:"h12"};this.meridiemCache=[DateTime.utc(2016,11,13,9),DateTime.utc(2016,11,13,19)].map((t=>this.extract(t,e,"dayperiod")))}return this.meridiemCache}))}eras(e){return listStuff(this,e,eras,(()=>{const t={era:e};return this.eraCache[e]||(this.eraCache[e]=[DateTime.utc(-40,1,1),DateTime.utc(2017,1,1)].map((e=>this.extract(e,t,"era")))),this.eraCache[e]}))}extract(e,t,n){const r=this.dtFormatter(e,t).formatToParts().find((e=>e.type.toLowerCase()===n));return r?r.value:null}numberFormatter(e={}){return new PolyNumberFormatter(this.intl,e.forceSimple||this.fastNumbers,e)}dtFormatter(e,t={}){return new PolyDateFormatter(e,this.intl,t)}relFormatter(e={}){return new PolyRelFormatter(this.intl,this.isEnglish(),e)}listFormatter(e={}){return getCachedLF(this.intl,e)}isEnglish(){return"en"===this.locale||"en-us"===this.locale.toLowerCase()||new Intl.DateTimeFormat(this.intl).resolvedOptions().locale.startsWith("en-us")}getWeekSettings(){return this.weekSettings?this.weekSettings:hasLocaleWeekInfo()?getCachedWeekInfo(this.locale):fallbackWeekSettings}getStartOfWeek(){return this.getWeekSettings().firstDay}getMinDaysInFirstWeek(){return this.getWeekSettings().minimalDays}getWeekendDays(){return this.getWeekSettings().weekend}equals(e){return this.locale===e.locale&&this.numberingSystem===e.numberingSystem&&this.outputCalendar===e.outputCalendar}}let singleton=null;class FixedOffsetZone extends Zone{static get utcInstance(){return null===singleton&&(singleton=new FixedOffsetZone(0)),singleton}static instance(e){return 0===e?FixedOffsetZone.utcInstance:new FixedOffsetZone(e)}static parseSpecifier(e){if(e){const t=e.match(/^utc(?:([+-]\d{1,2})(?::(\d{2}))?)?$/i);if(t)return new FixedOffsetZone(signedOffset(t[1],t[2]))}return null}constructor(e){super(),this.fixed=e}get type(){return"fixed"}get name(){return 0===this.fixed?"UTC":`UTC${formatOffset(this.fixed,"narrow")}`}get ianaName(){return 0===this.fixed?"Etc/UTC":`Etc/GMT${formatOffset(-this.fixed,"narrow")}`}offsetName(){return this.name}formatOffset(e,t){return formatOffset(this.fixed,t)}get isUniversal(){return!0}offset(){return this.fixed}equals(e){return"fixed"===e.type&&e.fixed===this.fixed}get isValid(){return!0}}class InvalidZone extends Zone{constructor(e){super(),this.zoneName=e}get type(){return"invalid"}get name(){return this.zoneName}get isUniversal(){return!1}offsetName(){return null}formatOffset(){return""}offset(){return NaN}equals(){return!1}get isValid(){return!1}}function normalizeZone(e,t){if(isUndefined(e)||null===e)return t;if(e instanceof Zone)return e;if(isString(e)){const n=e.toLowerCase();return"default"===n?t:"local"===n||"system"===n?SystemZone.instance:"utc"===n||"gmt"===n?FixedOffsetZone.utcInstance:FixedOffsetZone.parseSpecifier(n)||IANAZone.create(e)}return isNumber(e)?FixedOffsetZone.instance(e):"object"==typeof e&&"offset"in e&&"function"==typeof e.offset?e:new InvalidZone(e)}let throwOnInvalid,now=()=>Date.now(),defaultZone="system",defaultLocale=null,defaultNumberingSystem=null,defaultOutputCalendar=null,twoDigitCutoffYear=60,defaultWeekSettings=null;class Settings{static get now(){return now}static set now(e){now=e}static set defaultZone(e){defaultZone=e}static get defaultZone(){return normalizeZone(defaultZone,SystemZone.instance)}static get defaultLocale(){return defaultLocale}static set defaultLocale(e){defaultLocale=e}static get defaultNumberingSystem(){return defaultNumberingSystem}static set defaultNumberingSystem(e){defaultNumberingSystem=e}static get defaultOutputCalendar(){return defaultOutputCalendar}static set defaultOutputCalendar(e){defaultOutputCalendar=e}static get defaultWeekSettings(){return defaultWeekSettings}static set defaultWeekSettings(e){defaultWeekSettings=validateWeekSettings(e)}static get twoDigitCutoffYear(){return twoDigitCutoffYear}static set twoDigitCutoffYear(e){twoDigitCutoffYear=e%100}static get throwOnInvalid(){return throwOnInvalid}static set throwOnInvalid(e){throwOnInvalid=e}static resetCaches(){Locale.resetCache(),IANAZone.resetCache()}}class Invalid{constructor(e,t){this.reason=e,this.explanation=t}toMessage(){return this.explanation?`${this.reason}: ${this.explanation}`:this.reason}}const nonLeapLadder=[0,31,59,90,120,151,181,212,243,273,304,334],leapLadder=[0,31,60,91,121,152,182,213,244,274,305,335];function unitOutOfRange(e,t){return new Invalid("unit out of range",`you specified ${t} (of type ${typeof t}) as a ${e}, which is invalid`)}function dayOfWeek(e,t,n){const r=new Date(Date.UTC(e,t-1,n));e<100&&e>=0&&r.setUTCFullYear(r.getUTCFullYear()-1900);const i=r.getUTCDay();return 0===i?7:i}function computeOrdinal(e,t,n){return n+(isLeapYear(e)?leapLadder:nonLeapLadder)[t-1]}function uncomputeOrdinal(e,t){const n=isLeapYear(e)?leapLadder:nonLeapLadder,r=n.findIndex((e=>e<t));return{month:r+1,day:t-n[r]}}function isoWeekdayToLocal(e,t){return(e-t+7)%7+1}function gregorianToWeek(e,t=4,n=1){const{year:r,month:i,day:s}=e,a=computeOrdinal(r,i,s),o=isoWeekdayToLocal(dayOfWeek(r,i,s),n);let u,l=Math.floor((a-o+14-t)/7);return l<1?(u=r-1,l=weeksInWeekYear(u,t,n)):l>weeksInWeekYear(r,t,n)?(u=r+1,l=1):u=r,{weekYear:u,weekNumber:l,weekday:o,...timeObject(e)}}function weekToGregorian(e,t=4,n=1){const{weekYear:r,weekNumber:i,weekday:s}=e,a=isoWeekdayToLocal(dayOfWeek(r,1,t),n),o=daysInYear(r);let u,l=7*i+s-a-7+t;l<1?(u=r-1,l+=daysInYear(u)):l>o?(u=r+1,l-=daysInYear(r)):u=r;const{month:c,day:d}=uncomputeOrdinal(u,l);return{year:u,month:c,day:d,...timeObject(e)}}function gregorianToOrdinal(e){const{year:t,month:n,day:r}=e;return{year:t,ordinal:computeOrdinal(t,n,r),...timeObject(e)}}function ordinalToGregorian(e){const{year:t,ordinal:n}=e,{month:r,day:i}=uncomputeOrdinal(t,n);return{year:t,month:r,day:i,...timeObject(e)}}function usesLocalWeekValues(e,t){if(!isUndefined(e.localWeekday)||!isUndefined(e.localWeekNumber)||!isUndefined(e.localWeekYear)){if(!isUndefined(e.weekday)||!isUndefined(e.weekNumber)||!isUndefined(e.weekYear))throw new ConflictingSpecificationError("Cannot mix locale-based week fields with ISO-based week fields");return isUndefined(e.localWeekday)||(e.weekday=e.localWeekday),isUndefined(e.localWeekNumber)||(e.weekNumber=e.localWeekNumber),isUndefined(e.localWeekYear)||(e.weekYear=e.localWeekYear),delete e.localWeekday,delete e.localWeekNumber,delete e.localWeekYear,{minDaysInFirstWeek:t.getMinDaysInFirstWeek(),startOfWeek:t.getStartOfWeek()}}return{minDaysInFirstWeek:4,startOfWeek:1}}function hasInvalidWeekData(e,t=4,n=1){const r=isInteger(e.weekYear),i=integerBetween(e.weekNumber,1,weeksInWeekYear(e.weekYear,t,n)),s=integerBetween(e.weekday,1,7);return r?i?!s&&unitOutOfRange("weekday",e.weekday):unitOutOfRange("week",e.weekNumber):unitOutOfRange("weekYear",e.weekYear)}function hasInvalidOrdinalData(e){const t=isInteger(e.year),n=integerBetween(e.ordinal,1,daysInYear(e.year));return t?!n&&unitOutOfRange("ordinal",e.ordinal):unitOutOfRange("year",e.year)}function hasInvalidGregorianData(e){const t=isInteger(e.year),n=integerBetween(e.month,1,12),r=integerBetween(e.day,1,daysInMonth(e.year,e.month));return t?n?!r&&unitOutOfRange("day",e.day):unitOutOfRange("month",e.month):unitOutOfRange("year",e.year)}function hasInvalidTimeData(e){const{hour:t,minute:n,second:r,millisecond:i}=e,s=integerBetween(t,0,23)||24===t&&0===n&&0===r&&0===i,a=integerBetween(n,0,59),o=integerBetween(r,0,59),u=integerBetween(i,0,999);return s?a?o?!u&&unitOutOfRange("millisecond",i):unitOutOfRange("second",r):unitOutOfRange("minute",n):unitOutOfRange("hour",t)}function isUndefined(e){return void 0===e}function isNumber(e){return"number"==typeof e}function isInteger(e){return"number"==typeof e&&e%1==0}function isString(e){return"string"==typeof e}function isDate(e){return"[object Date]"===Object.prototype.toString.call(e)}function hasRelative(){try{return"undefined"!=typeof Intl&&!!Intl.RelativeTimeFormat}catch(e){return!1}}function hasLocaleWeekInfo(){try{return"undefined"!=typeof Intl&&!!Intl.Locale&&("weekInfo"in Intl.Locale.prototype||"getWeekInfo"in Intl.Locale.prototype)}catch(e){return!1}}function maybeArray(e){return Array.isArray(e)?e:[e]}function bestBy(e,t,n){if(0!==e.length)return e.reduce(((e,r)=>{const i=[t(r),r];return e&&n(e[0],i[0])===e[0]?e:i}),null)[1]}function pick(e,t){return t.reduce(((t,n)=>(t[n]=e[n],t)),{})}function hasOwnProperty(e,t){return Object.prototype.hasOwnProperty.call(e,t)}function validateWeekSettings(e){if(null==e)return null;if("object"!=typeof e)throw new InvalidArgumentError("Week settings must be an object");if(!integerBetween(e.firstDay,1,7)||!integerBetween(e.minimalDays,1,7)||!Array.isArray(e.weekend)||e.weekend.some((e=>!integerBetween(e,1,7))))throw new InvalidArgumentError("Invalid week settings");return{firstDay:e.firstDay,minimalDays:e.minimalDays,weekend:Array.from(e.weekend)}}function integerBetween(e,t,n){return isInteger(e)&&e>=t&&e<=n}function floorMod(e,t){return e-t*Math.floor(e/t)}function padStart(e,t=2){let n;return n=e<0?"-"+(""+-e).padStart(t,"0"):(""+e).padStart(t,"0"),n}function parseInteger(e){return isUndefined(e)||null===e||""===e?void 0:parseInt(e,10)}function parseFloating(e){return isUndefined(e)||null===e||""===e?void 0:parseFloat(e)}function parseMillis(e){if(!isUndefined(e)&&null!==e&&""!==e){const t=1e3*parseFloat("0."+e);return Math.floor(t)}}function roundTo(e,t,n=!1){const r=10**t;return(n?Math.trunc:Math.round)(e*r)/r}function isLeapYear(e){return e%4==0&&(e%100!=0||e%400==0)}function daysInYear(e){return isLeapYear(e)?366:365}function daysInMonth(e,t){const n=floorMod(t-1,12)+1;return 2===n?isLeapYear(e+(t-n)/12)?29:28:[31,null,31,30,31,30,31,31,30,31,30,31][n-1]}function objToLocalTS(e){let t=Date.UTC(e.year,e.month-1,e.day,e.hour,e.minute,e.second,e.millisecond);return e.year<100&&e.year>=0&&(t=new Date(t),t.setUTCFullYear(e.year,e.month-1,e.day)),+t}function firstWeekOffset(e,t,n){return-isoWeekdayToLocal(dayOfWeek(e,1,t),n)+t-1}function weeksInWeekYear(e,t=4,n=1){const r=firstWeekOffset(e,t,n),i=firstWeekOffset(e+1,t,n);return(daysInYear(e)-r+i)/7}function untruncateYear(e){return e>99?e:e>Settings.twoDigitCutoffYear?1900+e:2e3+e}function parseZoneInfo(e,t,n,r=null){const i=new Date(e),s={hourCycle:"h23",year:"numeric",month:"2-digit",day:"2-digit",hour:"2-digit",minute:"2-digit"};r&&(s.timeZone=r);const a={timeZoneName:t,...s},o=new Intl.DateTimeFormat(n,a).formatToParts(i).find((e=>"timezonename"===e.type.toLowerCase()));return o?o.value:null}function signedOffset(e,t){let n=parseInt(e,10);Number.isNaN(n)&&(n=0);const r=parseInt(t,10)||0;return 60*n+(n<0||Object.is(n,-0)?-r:r)}function asNumber(e){const t=Number(e);if("boolean"==typeof e||""===e||Number.isNaN(t))throw new InvalidArgumentError(`Invalid unit value ${e}`);return t}function normalizeObject(e,t){const n={};for(const r in e)if(hasOwnProperty(e,r)){const i=e[r];if(null==i)continue;n[t(r)]=asNumber(i)}return n}function formatOffset(e,t){const n=Math.trunc(Math.abs(e/60)),r=Math.trunc(Math.abs(e%60)),i=e>=0?"+":"-";switch(t){case"short":return`${i}${padStart(n,2)}:${padStart(r,2)}`;case"narrow":return`${i}${n}${r>0?`:${r}`:""}`;case"techie":return`${i}${padStart(n,2)}${padStart(r,2)}`;default:throw new RangeError(`Value format ${t} is out of range for property format`)}}function timeObject(e){return pick(e,["hour","minute","second","millisecond"])}const monthsLong=["January","February","March","April","May","June","July","August","September","October","November","December"],monthsShort=["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],monthsNarrow=["J","F","M","A","M","J","J","A","S","O","N","D"];function months(e){switch(e){case"narrow":return[...monthsNarrow];case"short":return[...monthsShort];case"long":return[...monthsLong];case"numeric":return["1","2","3","4","5","6","7","8","9","10","11","12"];case"2-digit":return["01","02","03","04","05","06","07","08","09","10","11","12"];default:return null}}const weekdaysLong=["Monday","Tuesday","Wednesday","Thursday","Friday","Saturday","Sunday"],weekdaysShort=["Mon","Tue","Wed","Thu","Fri","Sat","Sun"],weekdaysNarrow=["M","T","W","T","F","S","S"];function weekdays(e){switch(e){case"narrow":return[...weekdaysNarrow];case"short":return[...weekdaysShort];case"long":return[...weekdaysLong];case"numeric":return["1","2","3","4","5","6","7"];default:return null}}const meridiems=["AM","PM"],erasLong=["Before Christ","Anno Domini"],erasShort=["BC","AD"],erasNarrow=["B","A"];function eras(e){switch(e){case"narrow":return[...erasNarrow];case"short":return[...erasShort];case"long":return[...erasLong];default:return null}}function meridiemForDateTime(e){return meridiems[e.hour<12?0:1]}function weekdayForDateTime(e,t){return weekdays(t)[e.weekday-1]}function monthForDateTime(e,t){return months(t)[e.month-1]}function eraForDateTime(e,t){return eras(t)[e.year<0?0:1]}function formatRelativeTime(e,t,n="always",r=!1){const i={years:["year","yr."],quarters:["quarter","qtr."],months:["month","mo."],weeks:["week","wk."],days:["day","day","days"],hours:["hour","hr."],minutes:["minute","min."],seconds:["second","sec."]},s=-1===["hours","minutes","seconds"].indexOf(e);if("auto"===n&&s){const n="days"===e;switch(t){case 1:return n?"tomorrow":`next ${i[e][0]}`;case-1:return n?"yesterday":`last ${i[e][0]}`;case 0:return n?"today":`this ${i[e][0]}`}}const a=Object.is(t,-0)||t<0,o=Math.abs(t),u=1===o,l=i[e],c=r?u?l[1]:l[2]||l[1]:u?i[e][0]:e;return a?`${o} ${c} ago`:`in ${o} ${c}`}function stringifyTokens(e,t){let n="";for(const r of e)r.literal?n+=r.val:n+=t(r.val);return n}const macroTokenToFormatOpts={D:DATE_SHORT,DD:DATE_MED,DDD:DATE_FULL,DDDD:DATE_HUGE,t:TIME_SIMPLE,tt:TIME_WITH_SECONDS,ttt:TIME_WITH_SHORT_OFFSET,tttt:TIME_WITH_LONG_OFFSET,T:TIME_24_SIMPLE,TT:TIME_24_WITH_SECONDS,TTT:TIME_24_WITH_SHORT_OFFSET,TTTT:TIME_24_WITH_LONG_OFFSET,f:DATETIME_SHORT,ff:DATETIME_MED,fff:DATETIME_FULL,ffff:DATETIME_HUGE,F:DATETIME_SHORT_WITH_SECONDS,FF:DATETIME_MED_WITH_SECONDS,FFF:DATETIME_FULL_WITH_SECONDS,FFFF:DATETIME_HUGE_WITH_SECONDS};class Formatter{static create(e,t={}){return new Formatter(e,t)}static parseFormat(e){let t=null,n="",r=!1;const i=[];for(let s=0;s<e.length;s++){const a=e.charAt(s);"'"===a?(n.length>0&&i.push({literal:r||/^\s+$/.test(n),val:n}),t=null,n="",r=!r):r||a===t?n+=a:(n.length>0&&i.push({literal:/^\s+$/.test(n),val:n}),n=a,t=a)}return n.length>0&&i.push({literal:r||/^\s+$/.test(n),val:n}),i}static macroTokenToFormatOpts(e){return macroTokenToFormatOpts[e]}constructor(e,t){this.opts=t,this.loc=e,this.systemLoc=null}formatWithSystemDefault(e,t){null===this.systemLoc&&(this.systemLoc=this.loc.redefaultToSystem());return this.systemLoc.dtFormatter(e,{...this.opts,...t}).format()}dtFormatter(e,t={}){return this.loc.dtFormatter(e,{...this.opts,...t})}formatDateTime(e,t){return this.dtFormatter(e,t).format()}formatDateTimeParts(e,t){return this.dtFormatter(e,t).formatToParts()}formatInterval(e,t){return this.dtFormatter(e.start,t).dtf.formatRange(e.start.toJSDate(),e.end.toJSDate())}resolvedOptions(e,t){return this.dtFormatter(e,t).resolvedOptions()}num(e,t=0){if(this.opts.forceSimple)return padStart(e,t);const n={...this.opts};return t>0&&(n.padTo=t),this.loc.numberFormatter(n).format(e)}formatDateTimeFromString(e,t){const n="en"===this.loc.listingMode(),r=this.loc.outputCalendar&&"gregory"!==this.loc.outputCalendar,i=(t,n)=>this.loc.extract(e,t,n),s=t=>e.isOffsetFixed&&0===e.offset&&t.allowZ?"Z":e.isValid?e.zone.formatOffset(e.ts,t.format):"",a=(t,r)=>n?monthForDateTime(e,t):i(r?{month:t}:{month:t,day:"numeric"},"month"),o=(t,r)=>n?weekdayForDateTime(e,t):i(r?{weekday:t}:{weekday:t,month:"long",day:"numeric"},"weekday"),u=t=>{const n=Formatter.macroTokenToFormatOpts(t);return n?this.formatWithSystemDefault(e,n):t},l=t=>n?eraForDateTime(e,t):i({era:t},"era");return stringifyTokens(Formatter.parseFormat(t),(t=>{switch(t){case"S":return this.num(e.millisecond);case"u":case"SSS":return this.num(e.millisecond,3);case"s":return this.num(e.second);case"ss":return this.num(e.second,2);case"uu":return this.num(Math.floor(e.millisecond/10),2);case"uuu":return this.num(Math.floor(e.millisecond/100));case"m":return this.num(e.minute);case"mm":return this.num(e.minute,2);case"h":return this.num(e.hour%12==0?12:e.hour%12);case"hh":return this.num(e.hour%12==0?12:e.hour%12,2);case"H":return this.num(e.hour);case"HH":return this.num(e.hour,2);case"Z":return s({format:"narrow",allowZ:this.opts.allowZ});case"ZZ":return s({format:"short",allowZ:this.opts.allowZ});case"ZZZ":return s({format:"techie",allowZ:this.opts.allowZ});case"ZZZZ":return e.zone.offsetName(e.ts,{format:"short",locale:this.loc.locale});case"ZZZZZ":return e.zone.offsetName(e.ts,{format:"long",locale:this.loc.locale});case"z":return e.zoneName;case"a":return n?meridiemForDateTime(e):i({hour:"numeric",hourCycle:"h12"},"dayperiod");case"d":return r?i({day:"numeric"},"day"):this.num(e.day);case"dd":return r?i({day:"2-digit"},"day"):this.num(e.day,2);case"c":case"E":return this.num(e.weekday);case"ccc":return o("short",!0);case"cccc":return o("long",!0);case"ccccc":return o("narrow",!0);case"EEE":return o("short",!1);case"EEEE":return o("long",!1);case"EEEEE":return o("narrow",!1);case"L":return r?i({month:"numeric",day:"numeric"},"month"):this.num(e.month);case"LL":return r?i({month:"2-digit",day:"numeric"},"month"):this.num(e.month,2);case"LLL":return a("short",!0);case"LLLL":return a("long",!0);case"LLLLL":return a("narrow",!0);case"M":return r?i({month:"numeric"},"month"):this.num(e.month);case"MM":return r?i({month:"2-digit"},"month"):this.num(e.month,2);case"MMM":return a("short",!1);case"MMMM":return a("long",!1);case"MMMMM":return a("narrow",!1);case"y":return r?i({year:"numeric"},"year"):this.num(e.year);case"yy":return r?i({year:"2-digit"},"year"):this.num(e.year.toString().slice(-2),2);case"yyyy":return r?i({year:"numeric"},"year"):this.num(e.year,4);case"yyyyyy":return r?i({year:"numeric"},"year"):this.num(e.year,6);case"G":return l("short");case"GG":return l("long");case"GGGGG":return l("narrow");case"kk":return this.num(e.weekYear.toString().slice(-2),2);case"kkkk":return this.num(e.weekYear,4);case"W":return this.num(e.weekNumber);case"WW":return this.num(e.weekNumber,2);case"n":return this.num(e.localWeekNumber);case"nn":return this.num(e.localWeekNumber,2);case"ii":return this.num(e.localWeekYear.toString().slice(-2),2);case"iiii":return this.num(e.localWeekYear,4);case"o":return this.num(e.ordinal);case"ooo":return this.num(e.ordinal,3);case"q":return this.num(e.quarter);case"qq":return this.num(e.quarter,2);case"X":return this.num(Math.floor(e.ts/1e3));case"x":return this.num(e.ts);default:return u(t)}}))}formatDurationFromString(e,t){const n=e=>{switch(e[0]){case"S":return"millisecond";case"s":return"second";case"m":return"minute";case"h":return"hour";case"d":return"day";case"w":return"week";case"M":return"month";case"y":return"year";default:return null}},r=Formatter.parseFormat(t),i=r.reduce(((e,{literal:t,val:n})=>t?e:e.concat(n)),[]);return stringifyTokens(r,(e=>t=>{const r=n(t);return r?this.num(e.get(r),t.length):t})(e.shiftTo(...i.map(n).filter((e=>e)))))}}const ianaRegex=/[A-Za-z_+-]{1,256}(?::?\/[A-Za-z0-9_+-]{1,256}(?:\/[A-Za-z0-9_+-]{1,256})?)?/;function combineRegexes(...e){const t=e.reduce(((e,t)=>e+t.source),"");return RegExp(`^${t}$`)}function combineExtractors(...e){return t=>e.reduce((([e,n,r],i)=>{const[s,a,o]=i(t,r);return[{...e,...s},a||n,o]}),[{},null,1]).slice(0,2)}function parse(e,...t){if(null==e)return[null,null];for(const[n,r]of t){const t=n.exec(e);if(t)return r(t)}return[null,null]}function simpleParse(...e){return(t,n)=>{const r={};let i;for(i=0;i<e.length;i++)r[e[i]]=parseInteger(t[n+i]);return[r,null,n+i]}}const offsetRegex=/(?:(Z)|([+-]\d\d)(?::?(\d\d))?)/,isoExtendedZone=`(?:${offsetRegex.source}?(?:\\[(${ianaRegex.source})\\])?)?`,isoTimeBaseRegex=/(\d\d)(?::?(\d\d)(?::?(\d\d)(?:[.,](\d{1,30}))?)?)?/,isoTimeRegex=RegExp(`${isoTimeBaseRegex.source}${isoExtendedZone}`),isoTimeExtensionRegex=RegExp(`(?:T${isoTimeRegex.source})?`),isoYmdRegex=/([+-]\d{6}|\d{4})(?:-?(\d\d)(?:-?(\d\d))?)?/,isoWeekRegex=/(\d{4})-?W(\d\d)(?:-?(\d))?/,isoOrdinalRegex=/(\d{4})-?(\d{3})/,extractISOWeekData=simpleParse("weekYear","weekNumber","weekDay"),extractISOOrdinalData=simpleParse("year","ordinal"),sqlYmdRegex=/(\d{4})-(\d\d)-(\d\d)/,sqlTimeRegex=RegExp(`${isoTimeBaseRegex.source} ?(?:${offsetRegex.source}|(${ianaRegex.source}))?`),sqlTimeExtensionRegex=RegExp(`(?: ${sqlTimeRegex.source})?`);function int(e,t,n){const r=e[t];return isUndefined(r)?n:parseInteger(r)}function extractISOYmd(e,t){return[{year:int(e,t),month:int(e,t+1,1),day:int(e,t+2,1)},null,t+3]}function extractISOTime(e,t){return[{hours:int(e,t,0),minutes:int(e,t+1,0),seconds:int(e,t+2,0),milliseconds:parseMillis(e[t+3])},null,t+4]}function extractISOOffset(e,t){const n=!e[t]&&!e[t+1],r=signedOffset(e[t+1],e[t+2]);return[{},n?null:FixedOffsetZone.instance(r),t+3]}function extractIANAZone(e,t){return[{},e[t]?IANAZone.create(e[t]):null,t+1]}const isoTimeOnly=RegExp(`^T?${isoTimeBaseRegex.source}$`),isoDuration=/^-?P(?:(?:(-?\d{1,20}(?:\.\d{1,20})?)Y)?(?:(-?\d{1,20}(?:\.\d{1,20})?)M)?(?:(-?\d{1,20}(?:\.\d{1,20})?)W)?(?:(-?\d{1,20}(?:\.\d{1,20})?)D)?(?:T(?:(-?\d{1,20}(?:\.\d{1,20})?)H)?(?:(-?\d{1,20}(?:\.\d{1,20})?)M)?(?:(-?\d{1,20})(?:[.,](-?\d{1,20}))?S)?)?)$/;function extractISODuration(e){const[t,n,r,i,s,a,o,u,l]=e,c="-"===t[0],d=u&&"-"===u[0],m=(e,t=!1)=>void 0!==e&&(t||e&&c)?-e:e;return[{years:m(parseFloating(n)),months:m(parseFloating(r)),weeks:m(parseFloating(i)),days:m(parseFloating(s)),hours:m(parseFloating(a)),minutes:m(parseFloating(o)),seconds:m(parseFloating(u),"-0"===u),milliseconds:m(parseMillis(l),d)}]}const obsOffsets={GMT:0,EDT:-240,EST:-300,CDT:-300,CST:-360,MDT:-360,MST:-420,PDT:-420,PST:-480};function fromStrings(e,t,n,r,i,s,a){const o={year:2===t.length?untruncateYear(parseInteger(t)):parseInteger(t),month:monthsShort.indexOf(n)+1,day:parseInteger(r),hour:parseInteger(i),minute:parseInteger(s)};return a&&(o.second=parseInteger(a)),e&&(o.weekday=e.length>3?weekdaysLong.indexOf(e)+1:weekdaysShort.indexOf(e)+1),o}const rfc2822=/^(?:(Mon|Tue|Wed|Thu|Fri|Sat|Sun),\s)?(\d{1,2})\s(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\s(\d{2,4})\s(\d\d):(\d\d)(?::(\d\d))?\s(?:(UT|GMT|[ECMP][SD]T)|([Zz])|(?:([+-]\d\d)(\d\d)))$/;function extractRFC2822(e){const[,t,n,r,i,s,a,o,u,l,c,d]=e,m=fromStrings(t,i,r,n,s,a,o);let h;return h=u?obsOffsets[u]:l?0:signedOffset(c,d),[m,new FixedOffsetZone(h)]}function preprocessRFC2822(e){return e.replace(/\([^()]*\)|[\n\t]/g," ").replace(/(\s\s+)/g," ").trim()}const rfc1123=/^(Mon|Tue|Wed|Thu|Fri|Sat|Sun), (\d\d) (Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) (\d{4}) (\d\d):(\d\d):(\d\d) GMT$/,rfc850=/^(Monday|Tuesday|Wednesday|Thursday|Friday|Saturday|Sunday), (\d\d)-(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)-(\d\d) (\d\d):(\d\d):(\d\d) GMT$/,ascii=/^(Mon|Tue|Wed|Thu|Fri|Sat|Sun) (Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) ( \d|\d\d) (\d\d):(\d\d):(\d\d) (\d{4})$/;function extractRFC1123Or850(e){const[,t,n,r,i,s,a,o]=e;return[fromStrings(t,i,r,n,s,a,o),FixedOffsetZone.utcInstance]}function extractASCII(e){const[,t,n,r,i,s,a,o]=e;return[fromStrings(t,o,n,r,i,s,a),FixedOffsetZone.utcInstance]}const isoYmdWithTimeExtensionRegex=combineRegexes(isoYmdRegex,isoTimeExtensionRegex),isoWeekWithTimeExtensionRegex=combineRegexes(isoWeekRegex,isoTimeExtensionRegex),isoOrdinalWithTimeExtensionRegex=combineRegexes(isoOrdinalRegex,isoTimeExtensionRegex),isoTimeCombinedRegex=combineRegexes(isoTimeRegex),extractISOYmdTimeAndOffset=combineExtractors(extractISOYmd,extractISOTime,extractISOOffset,extractIANAZone),extractISOWeekTimeAndOffset=combineExtractors(extractISOWeekData,extractISOTime,extractISOOffset,extractIANAZone),extractISOOrdinalDateAndTime=combineExtractors(extractISOOrdinalData,extractISOTime,extractISOOffset,extractIANAZone),extractISOTimeAndOffset=combineExtractors(extractISOTime,extractISOOffset,extractIANAZone);function parseISODate(e){return parse(e,[isoYmdWithTimeExtensionRegex,extractISOYmdTimeAndOffset],[isoWeekWithTimeExtensionRegex,extractISOWeekTimeAndOffset],[isoOrdinalWithTimeExtensionRegex,extractISOOrdinalDateAndTime],[isoTimeCombinedRegex,extractISOTimeAndOffset])}function parseRFC2822Date(e){return parse(preprocessRFC2822(e),[rfc2822,extractRFC2822])}function parseHTTPDate(e){return parse(e,[rfc1123,extractRFC1123Or850],[rfc850,extractRFC1123Or850],[ascii,extractASCII])}function parseISODuration(e){return parse(e,[isoDuration,extractISODuration])}const extractISOTimeOnly=combineExtractors(extractISOTime);function parseISOTimeOnly(e){return parse(e,[isoTimeOnly,extractISOTimeOnly])}const sqlYmdWithTimeExtensionRegex=combineRegexes(sqlYmdRegex,sqlTimeExtensionRegex),sqlTimeCombinedRegex=combineRegexes(sqlTimeRegex),extractISOTimeOffsetAndIANAZone=combineExtractors(extractISOTime,extractISOOffset,extractIANAZone);function parseSQL(e){return parse(e,[sqlYmdWithTimeExtensionRegex,extractISOYmdTimeAndOffset],[sqlTimeCombinedRegex,extractISOTimeOffsetAndIANAZone])}const INVALID$2="Invalid Duration",lowOrderMatrix={weeks:{days:7,hours:168,minutes:10080,seconds:604800,milliseconds:6048e5},days:{hours:24,minutes:1440,seconds:86400,milliseconds:864e5},hours:{minutes:60,seconds:3600,milliseconds:36e5},minutes:{seconds:60,milliseconds:6e4},seconds:{milliseconds:1e3}},casualMatrix={years:{quarters:4,months:12,weeks:52,days:365,hours:8760,minutes:525600,seconds:31536e3,milliseconds:31536e6},quarters:{months:3,weeks:13,days:91,hours:2184,minutes:131040,seconds:7862400,milliseconds:78624e5},months:{weeks:4,days:30,hours:720,minutes:43200,seconds:2592e3,milliseconds:2592e6},...lowOrderMatrix},daysInYearAccurate=365.2425,daysInMonthAccurate=30.436875,accurateMatrix={years:{quarters:4,months:12,weeks:52.1775,days:365.2425,hours:8765.82,minutes:525949.2,seconds:525949.2*60,milliseconds:525949.2*60*1e3},quarters:{months:3,weeks:13.044375,days:91.310625,hours:2191.455,minutes:131487.3,seconds:525949.2*60/4,milliseconds:7889237999.999999},months:{weeks:30.436875/7,days:30.436875,hours:730.485,minutes:43829.1,seconds:2629746,milliseconds:2629746e3},...lowOrderMatrix},orderedUnits$1=["years","quarters","months","weeks","days","hours","minutes","seconds","milliseconds"],reverseUnits=orderedUnits$1.slice(0).reverse();function clone$1(e,t,n=!1){const r={values:n?t.values:{...e.values,...t.values||{}},loc:e.loc.clone(t.loc),conversionAccuracy:t.conversionAccuracy||e.conversionAccuracy,matrix:t.matrix||e.matrix};return new Duration(r)}function durationToMillis(e,t){let n=t.milliseconds??0;for(const r of reverseUnits.slice(1))t[r]&&(n+=t[r]*e[r].milliseconds);return n}function normalizeValues(e,t){const n=durationToMillis(e,t)<0?-1:1;orderedUnits$1.reduceRight(((r,i)=>{if(isUndefined(t[i]))return r;if(r){const s=t[r]*n,a=e[i][r],o=Math.floor(s/a);t[i]+=o*n,t[r]-=o*a*n}return i}),null),orderedUnits$1.reduce(((n,r)=>{if(isUndefined(t[r]))return n;if(n){const i=t[n]%1;t[n]-=i,t[r]+=i*e[n][r]}return r}),null)}function removeZeroes(e){const t={};for(const[n,r]of Object.entries(e))0!==r&&(t[n]=r);return t}class Duration{constructor(e){const t="longterm"===e.conversionAccuracy||!1;let n=t?accurateMatrix:casualMatrix;e.matrix&&(n=e.matrix),this.values=e.values,this.loc=e.loc||Locale.create(),this.conversionAccuracy=t?"longterm":"casual",this.invalid=e.invalid||null,this.matrix=n,this.isLuxonDuration=!0}static fromMillis(e,t){return Duration.fromObject({milliseconds:e},t)}static fromObject(e,t={}){if(null==e||"object"!=typeof e)throw new InvalidArgumentError("Duration.fromObject: argument expected to be an object, got "+(null===e?"null":typeof e));return new Duration({values:normalizeObject(e,Duration.normalizeUnit),loc:Locale.fromObject(t),conversionAccuracy:t.conversionAccuracy,matrix:t.matrix})}static fromDurationLike(e){if(isNumber(e))return Duration.fromMillis(e);if(Duration.isDuration(e))return e;if("object"==typeof e)return Duration.fromObject(e);throw new InvalidArgumentError(`Unknown duration argument ${e} of type ${typeof e}`)}static fromISO(e,t){const[n]=parseISODuration(e);return n?Duration.fromObject(n,t):Duration.invalid("unparsable",`the input "${e}" can't be parsed as ISO 8601`)}static fromISOTime(e,t){const[n]=parseISOTimeOnly(e);return n?Duration.fromObject(n,t):Duration.invalid("unparsable",`the input "${e}" can't be parsed as ISO 8601`)}static invalid(e,t=null){if(!e)throw new InvalidArgumentError("need to specify a reason the Duration is invalid");const n=e instanceof Invalid?e:new Invalid(e,t);if(Settings.throwOnInvalid)throw new InvalidDurationError(n);return new Duration({invalid:n})}static normalizeUnit(e){const t={year:"years",years:"years",quarter:"quarters",quarters:"quarters",month:"months",months:"months",week:"weeks",weeks:"weeks",day:"days",days:"days",hour:"hours",hours:"hours",minute:"minutes",minutes:"minutes",second:"seconds",seconds:"seconds",millisecond:"milliseconds",milliseconds:"milliseconds"}[e?e.toLowerCase():e];if(!t)throw new InvalidUnitError(e);return t}static isDuration(e){return e&&e.isLuxonDuration||!1}get locale(){return this.isValid?this.loc.locale:null}get numberingSystem(){return this.isValid?this.loc.numberingSystem:null}toFormat(e,t={}){const n={...t,floor:!1!==t.round&&!1!==t.floor};return this.isValid?Formatter.create(this.loc,n).formatDurationFromString(this,e):INVALID$2}toHuman(e={}){if(!this.isValid)return INVALID$2;const t=orderedUnits$1.map((t=>{const n=this.values[t];return isUndefined(n)?null:this.loc.numberFormatter({style:"unit",unitDisplay:"long",...e,unit:t.slice(0,-1)}).format(n)})).filter((e=>e));return this.loc.listFormatter({type:"conjunction",style:e.listStyle||"narrow",...e}).format(t)}toObject(){return this.isValid?{...this.values}:{}}toISO(){if(!this.isValid)return null;let e="P";return 0!==this.years&&(e+=this.years+"Y"),0===this.months&&0===this.quarters||(e+=this.months+3*this.quarters+"M"),0!==this.weeks&&(e+=this.weeks+"W"),0!==this.days&&(e+=this.days+"D"),0===this.hours&&0===this.minutes&&0===this.seconds&&0===this.milliseconds||(e+="T"),0!==this.hours&&(e+=this.hours+"H"),0!==this.minutes&&(e+=this.minutes+"M"),0===this.seconds&&0===this.milliseconds||(e+=roundTo(this.seconds+this.milliseconds/1e3,3)+"S"),"P"===e&&(e+="T0S"),e}toISOTime(e={}){if(!this.isValid)return null;const t=this.toMillis();if(t<0||t>=864e5)return null;e={suppressMilliseconds:!1,suppressSeconds:!1,includePrefix:!1,format:"extended",...e,includeOffset:!1};return DateTime.fromMillis(t,{zone:"UTC"}).toISOTime(e)}toJSON(){return this.toISO()}toString(){return this.toISO()}[Symbol.for("nodejs.util.inspect.custom")](){return this.isValid?`Duration { values: ${JSON.stringify(this.values)} }`:`Duration { Invalid, reason: ${this.invalidReason} }`}toMillis(){return this.isValid?durationToMillis(this.matrix,this.values):NaN}valueOf(){return this.toMillis()}plus(e){if(!this.isValid)return this;const t=Duration.fromDurationLike(e),n={};for(const e of orderedUnits$1)(hasOwnProperty(t.values,e)||hasOwnProperty(this.values,e))&&(n[e]=t.get(e)+this.get(e));return clone$1(this,{values:n},!0)}minus(e){if(!this.isValid)return this;const t=Duration.fromDurationLike(e);return this.plus(t.negate())}mapUnits(e){if(!this.isValid)return this;const t={};for(const n of Object.keys(this.values))t[n]=asNumber(e(this.values[n],n));return clone$1(this,{values:t},!0)}get(e){return this[Duration.normalizeUnit(e)]}set(e){if(!this.isValid)return this;return clone$1(this,{values:{...this.values,...normalizeObject(e,Duration.normalizeUnit)}})}reconfigure({locale:e,numberingSystem:t,conversionAccuracy:n,matrix:r}={}){return clone$1(this,{loc:this.loc.clone({locale:e,numberingSystem:t}),matrix:r,conversionAccuracy:n})}as(e){return this.isValid?this.shiftTo(e).get(e):NaN}normalize(){if(!this.isValid)return this;const e=this.toObject();return normalizeValues(this.matrix,e),clone$1(this,{values:e},!0)}rescale(){if(!this.isValid)return this;return clone$1(this,{values:removeZeroes(this.normalize().shiftToAll().toObject())},!0)}shiftTo(...e){if(!this.isValid)return this;if(0===e.length)return this;e=e.map((e=>Duration.normalizeUnit(e)));const t={},n={},r=this.toObject();let i;for(const s of orderedUnits$1)if(e.indexOf(s)>=0){i=s;let e=0;for(const t in n)e+=this.matrix[t][s]*n[t],n[t]=0;isNumber(r[s])&&(e+=r[s]);const a=Math.trunc(e);t[s]=a,n[s]=(1e3*e-1e3*a)/1e3}else isNumber(r[s])&&(n[s]=r[s]);for(const e in n)0!==n[e]&&(t[i]+=e===i?n[e]:n[e]/this.matrix[i][e]);return normalizeValues(this.matrix,t),clone$1(this,{values:t},!0)}shiftToAll(){return this.isValid?this.shiftTo("years","months","weeks","days","hours","minutes","seconds","milliseconds"):this}negate(){if(!this.isValid)return this;const e={};for(const t of Object.keys(this.values))e[t]=0===this.values[t]?0:-this.values[t];return clone$1(this,{values:e},!0)}get years(){return this.isValid?this.values.years||0:NaN}get quarters(){return this.isValid?this.values.quarters||0:NaN}get months(){return this.isValid?this.values.months||0:NaN}get weeks(){return this.isValid?this.values.weeks||0:NaN}get days(){return this.isValid?this.values.days||0:NaN}get hours(){return this.isValid?this.values.hours||0:NaN}get minutes(){return this.isValid?this.values.minutes||0:NaN}get seconds(){return this.isValid?this.values.seconds||0:NaN}get milliseconds(){return this.isValid?this.values.milliseconds||0:NaN}get isValid(){return null===this.invalid}get invalidReason(){return this.invalid?this.invalid.reason:null}get invalidExplanation(){return this.invalid?this.invalid.explanation:null}equals(e){if(!this.isValid||!e.isValid)return!1;if(!this.loc.equals(e.loc))return!1;for(const r of orderedUnits$1)if(t=this.values[r],n=e.values[r],!(void 0===t||0===t?void 0===n||0===n:t===n))return!1;var t,n;return!0}}const INVALID$1="Invalid Interval";function validateStartEnd(e,t){return e&&e.isValid?t&&t.isValid?t<e?Interval.invalid("end before start",`The end of an interval must be after its start, but you had start=${e.toISO()} and end=${t.toISO()}`):null:Interval.invalid("missing or invalid end"):Interval.invalid("missing or invalid start")}class Interval{constructor(e){this.s=e.start,this.e=e.end,this.invalid=e.invalid||null,this.isLuxonInterval=!0}static invalid(e,t=null){if(!e)throw new InvalidArgumentError("need to specify a reason the Interval is invalid");const n=e instanceof Invalid?e:new Invalid(e,t);if(Settings.throwOnInvalid)throw new InvalidIntervalError(n);return new Interval({invalid:n})}static fromDateTimes(e,t){const n=friendlyDateTime(e),r=friendlyDateTime(t),i=validateStartEnd(n,r);return null==i?new Interval({start:n,end:r}):i}static after(e,t){const n=Duration.fromDurationLike(t),r=friendlyDateTime(e);return Interval.fromDateTimes(r,r.plus(n))}static before(e,t){const n=Duration.fromDurationLike(t),r=friendlyDateTime(e);return Interval.fromDateTimes(r.minus(n),r)}static fromISO(e,t){const[n,r]=(e||"").split("/",2);if(n&&r){let e,i,s,a;try{e=DateTime.fromISO(n,t),i=e.isValid}catch(r){i=!1}try{s=DateTime.fromISO(r,t),a=s.isValid}catch(r){a=!1}if(i&&a)return Interval.fromDateTimes(e,s);if(i){const n=Duration.fromISO(r,t);if(n.isValid)return Interval.after(e,n)}else if(a){const e=Duration.fromISO(n,t);if(e.isValid)return Interval.before(s,e)}}return Interval.invalid("unparsable",`the input "${e}" can't be parsed as ISO 8601`)}static isInterval(e){return e&&e.isLuxonInterval||!1}get start(){return this.isValid?this.s:null}get end(){return this.isValid?this.e:null}get isValid(){return null===this.invalidReason}get invalidReason(){return this.invalid?this.invalid.reason:null}get invalidExplanation(){return this.invalid?this.invalid.explanation:null}length(e="milliseconds"){return this.isValid?this.toDuration(e).get(e):NaN}count(e="milliseconds",t){if(!this.isValid)return NaN;const n=this.start.startOf(e,t);let r;return r=t?.useLocaleWeeks?this.end.reconfigure({locale:n.locale}):this.end,r=r.startOf(e,t),Math.floor(r.diff(n,e).get(e))+(r.valueOf()!==this.end.valueOf())}hasSame(e){return!!this.isValid&&(this.isEmpty()||this.e.minus(1).hasSame(this.s,e))}isEmpty(){return this.s.valueOf()===this.e.valueOf()}isAfter(e){return!!this.isValid&&this.s>e}isBefore(e){return!!this.isValid&&this.e<=e}contains(e){return!!this.isValid&&(this.s<=e&&this.e>e)}set({start:e,end:t}={}){return this.isValid?Interval.fromDateTimes(e||this.s,t||this.e):this}splitAt(...e){if(!this.isValid)return[];const t=e.map(friendlyDateTime).filter((e=>this.contains(e))).sort(((e,t)=>e.toMillis()-t.toMillis())),n=[];let{s:r}=this,i=0;for(;r<this.e;){const e=t[i]||this.e,s=+e>+this.e?this.e:e;n.push(Interval.fromDateTimes(r,s)),r=s,i+=1}return n}splitBy(e){const t=Duration.fromDurationLike(e);if(!this.isValid||!t.isValid||0===t.as("milliseconds"))return[];let n,{s:r}=this,i=1;const s=[];for(;r<this.e;){const e=this.start.plus(t.mapUnits((e=>e*i)));n=+e>+this.e?this.e:e,s.push(Interval.fromDateTimes(r,n)),r=n,i+=1}return s}divideEqually(e){return this.isValid?this.splitBy(this.length()/e).slice(0,e):[]}overlaps(e){return this.e>e.s&&this.s<e.e}abutsStart(e){return!!this.isValid&&+this.e==+e.s}abutsEnd(e){return!!this.isValid&&+e.e==+this.s}engulfs(e){return!!this.isValid&&(this.s<=e.s&&this.e>=e.e)}equals(e){return!(!this.isValid||!e.isValid)&&(this.s.equals(e.s)&&this.e.equals(e.e))}intersection(e){if(!this.isValid)return this;const t=this.s>e.s?this.s:e.s,n=this.e<e.e?this.e:e.e;return t>=n?null:Interval.fromDateTimes(t,n)}union(e){if(!this.isValid)return this;const t=this.s<e.s?this.s:e.s,n=this.e>e.e?this.e:e.e;return Interval.fromDateTimes(t,n)}static merge(e){const[t,n]=e.sort(((e,t)=>e.s-t.s)).reduce((([e,t],n)=>t?t.overlaps(n)||t.abutsStart(n)?[e,t.union(n)]:[e.concat([t]),n]:[e,n]),[[],null]);return n&&t.push(n),t}static xor(e){let t=null,n=0;const r=[],i=e.map((e=>[{time:e.s,type:"s"},{time:e.e,type:"e"}])),s=Array.prototype.concat(...i).sort(((e,t)=>e.time-t.time));for(const e of s)n+="s"===e.type?1:-1,1===n?t=e.time:(t&&+t!=+e.time&&r.push(Interval.fromDateTimes(t,e.time)),t=null);return Interval.merge(r)}difference(...e){return Interval.xor([this].concat(e)).map((e=>this.intersection(e))).filter((e=>e&&!e.isEmpty()))}toString(){return this.isValid?`[${this.s.toISO()} – ${this.e.toISO()})`:INVALID$1}[Symbol.for("nodejs.util.inspect.custom")](){return this.isValid?`Interval { start: ${this.s.toISO()}, end: ${this.e.toISO()} }`:`Interval { Invalid, reason: ${this.invalidReason} }`}toLocaleString(e=DATE_SHORT,t={}){return this.isValid?Formatter.create(this.s.loc.clone(t),e).formatInterval(this):INVALID$1}toISO(e){return this.isValid?`${this.s.toISO(e)}/${this.e.toISO(e)}`:INVALID$1}toISODate(){return this.isValid?`${this.s.toISODate()}/${this.e.toISODate()}`:INVALID$1}toISOTime(e){return this.isValid?`${this.s.toISOTime(e)}/${this.e.toISOTime(e)}`:INVALID$1}toFormat(e,{separator:t=" – "}={}){return this.isValid?`${this.s.toFormat(e)}${t}${this.e.toFormat(e)}`:INVALID$1}toDuration(e,t){return this.isValid?this.e.diff(this.s,e,t):Duration.invalid(this.invalidReason)}mapEndpoints(e){return Interval.fromDateTimes(e(this.s),e(this.e))}}class Info{static hasDST(e=Settings.defaultZone){const t=DateTime.now().setZone(e).set({month:12});return!e.isUniversal&&t.offset!==t.set({month:6}).offset}static isValidIANAZone(e){return IANAZone.isValidZone(e)}static normalizeZone(e){return normalizeZone(e,Settings.defaultZone)}static getStartOfWeek({locale:e=null,locObj:t=null}={}){return(t||Locale.create(e)).getStartOfWeek()}static getMinimumDaysInFirstWeek({locale:e=null,locObj:t=null}={}){return(t||Locale.create(e)).getMinDaysInFirstWeek()}static getWeekendWeekdays({locale:e=null,locObj:t=null}={}){return(t||Locale.create(e)).getWeekendDays().slice()}static months(e="long",{locale:t=null,numberingSystem:n=null,locObj:r=null,outputCalendar:i="gregory"}={}){return(r||Locale.create(t,n,i)).months(e)}static monthsFormat(e="long",{locale:t=null,numberingSystem:n=null,locObj:r=null,outputCalendar:i="gregory"}={}){return(r||Locale.create(t,n,i)).months(e,!0)}static weekdays(e="long",{locale:t=null,numberingSystem:n=null,locObj:r=null}={}){return(r||Locale.create(t,n,null)).weekdays(e)}static weekdaysFormat(e="long",{locale:t=null,numberingSystem:n=null,locObj:r=null}={}){return(r||Locale.create(t,n,null)).weekdays(e,!0)}static meridiems({locale:e=null}={}){return Locale.create(e).meridiems()}static eras(e="short",{locale:t=null}={}){return Locale.create(t,null,"gregory").eras(e)}static features(){return{relative:hasRelative(),localeWeek:hasLocaleWeekInfo()}}}function dayDiff(e,t){const n=e=>e.toUTC(0,{keepLocalTime:!0}).startOf("day").valueOf(),r=n(t)-n(e);return Math.floor(Duration.fromMillis(r).as("days"))}function highOrderDiffs(e,t,n){const r=[["years",(e,t)=>t.year-e.year],["quarters",(e,t)=>t.quarter-e.quarter+4*(t.year-e.year)],["months",(e,t)=>t.month-e.month+12*(t.year-e.year)],["weeks",(e,t)=>{const n=dayDiff(e,t);return(n-n%7)/7}],["days",dayDiff]],i={},s=e;let a,o;for(const[u,l]of r)n.indexOf(u)>=0&&(a=u,i[u]=l(e,t),o=s.plus(i),o>t?(i[u]--,(e=s.plus(i))>t&&(o=e,i[u]--,e=s.plus(i))):e=o);return[e,i,o,a]}function diff(e,t,n,r){let[i,s,a,o]=highOrderDiffs(e,t,n);const u=t-i,l=n.filter((e=>["hours","minutes","seconds","milliseconds"].indexOf(e)>=0));0===l.length&&(a<t&&(a=i.plus({[o]:1})),a!==i&&(s[o]=(s[o]||0)+u/(a-i)));const c=Duration.fromObject(s,r);return l.length>0?Duration.fromMillis(u,r).shiftTo(...l).plus(c):c}const numberingSystems={arab:"[٠-٩]",arabext:"[۰-۹]",bali:"[᭐-᭙]",beng:"[০-৯]",deva:"[०-९]",fullwide:"[０-９]",gujr:"[૦-૯]",hanidec:"[〇|一|二|三|四|五|六|七|八|九]",khmr:"[០-៩]",knda:"[೦-೯]",laoo:"[໐-໙]",limb:"[᥆-᥏]",mlym:"[൦-൯]",mong:"[᠐-᠙]",mymr:"[၀-၉]",orya:"[୦-୯]",tamldec:"[௦-௯]",telu:"[౦-౯]",thai:"[๐-๙]",tibt:"[༠-༩]",latn:"\\d"},numberingSystemsUTF16={arab:[1632,1641],arabext:[1776,1785],bali:[6992,7001],beng:[2534,2543],deva:[2406,2415],fullwide:[65296,65303],gujr:[2790,2799],khmr:[6112,6121],knda:[3302,3311],laoo:[3792,3801],limb:[6470,6479],mlym:[3430,3439],mong:[6160,6169],mymr:[4160,4169],orya:[2918,2927],tamldec:[3046,3055],telu:[3174,3183],thai:[3664,3673],tibt:[3872,3881]},hanidecChars=numberingSystems.hanidec.replace(/[\[|\]]/g,"").split("");function parseDigits(e){let t=parseInt(e,10);if(isNaN(t)){t="";for(let n=0;n<e.length;n++){const r=e.charCodeAt(n);if(-1!==e[n].search(numberingSystems.hanidec))t+=hanidecChars.indexOf(e[n]);else for(const e in numberingSystemsUTF16){const[n,i]=numberingSystemsUTF16[e];r>=n&&r<=i&&(t+=r-n)}}return parseInt(t,10)}return t}function digitRegex({numberingSystem:e},t=""){return new RegExp(`${numberingSystems[e||"latn"]}${t}`)}const MISSING_FTP="missing Intl.DateTimeFormat.formatToParts support";function intUnit(e,t=(e=>e)){return{regex:e,deser:([e])=>t(parseDigits(e))}}const NBSP=String.fromCharCode(160),spaceOrNBSP=`[ ${NBSP}]`,spaceOrNBSPRegExp=new RegExp(spaceOrNBSP,"g");function fixListRegex(e){return e.replace(/\./g,"\\.?").replace(spaceOrNBSPRegExp,spaceOrNBSP)}function stripInsensitivities(e){return e.replace(/\./g,"").replace(spaceOrNBSPRegExp," ").toLowerCase()}function oneOf(e,t){return null===e?null:{regex:RegExp(e.map(fixListRegex).join("|")),deser:([n])=>e.findIndex((e=>stripInsensitivities(n)===stripInsensitivities(e)))+t}}function offset(e,t){return{regex:e,deser:([,e,t])=>signedOffset(e,t),groups:t}}function simple(e){return{regex:e,deser:([e])=>e}}function escapeToken(e){return e.replace(/[\-\[\]{}()*+?.,\\\^$|#\s]/g,"\\$&")}function unitForToken(e,t){const n=digitRegex(t),r=digitRegex(t,"{2}"),i=digitRegex(t,"{3}"),s=digitRegex(t,"{4}"),a=digitRegex(t,"{6}"),o=digitRegex(t,"{1,2}"),u=digitRegex(t,"{1,3}"),l=digitRegex(t,"{1,6}"),c=digitRegex(t,"{1,9}"),d=digitRegex(t,"{2,4}"),m=digitRegex(t,"{4,6}"),h=e=>({regex:RegExp(escapeToken(e.val)),deser:([e])=>e,literal:!0}),f=(f=>{if(e.literal)return h(f);switch(f.val){case"G":return oneOf(t.eras("short"),0);case"GG":return oneOf(t.eras("long"),0);case"y":return intUnit(l);case"yy":case"kk":return intUnit(d,untruncateYear);case"yyyy":case"kkkk":return intUnit(s);case"yyyyy":return intUnit(m);case"yyyyyy":return intUnit(a);case"M":case"L":case"d":case"H":case"h":case"m":case"q":case"s":case"W":return intUnit(o);case"MM":case"LL":case"dd":case"HH":case"hh":case"mm":case"qq":case"ss":case"WW":return intUnit(r);case"MMM":return oneOf(t.months("short",!0),1);case"MMMM":return oneOf(t.months("long",!0),1);case"LLL":return oneOf(t.months("short",!1),1);case"LLLL":return oneOf(t.months("long",!1),1);case"o":case"S":return intUnit(u);case"ooo":case"SSS":return intUnit(i);case"u":return simple(c);case"uu":return simple(o);case"uuu":case"E":case"c":return intUnit(n);case"a":return oneOf(t.meridiems(),0);case"EEE":return oneOf(t.weekdays("short",!1),1);case"EEEE":return oneOf(t.weekdays("long",!1),1);case"ccc":return oneOf(t.weekdays("short",!0),1);case"cccc":return oneOf(t.weekdays("long",!0),1);case"Z":case"ZZ":return offset(new RegExp(`([+-]${o.source})(?::(${r.source}))?`),2);case"ZZZ":return offset(new RegExp(`([+-]${o.source})(${r.source})?`),2);case"z":return simple(/[a-z_+-/]{1,256}?/i);case" ":return simple(/[^\S\n\r]/);default:return h(f)}})(e)||{invalidReason:MISSING_FTP};return f.token=e,f}const partTypeStyleToTokenVal={year:{"2-digit":"yy",numeric:"yyyyy"},month:{numeric:"M","2-digit":"MM",short:"MMM",long:"MMMM"},day:{numeric:"d","2-digit":"dd"},weekday:{short:"EEE",long:"EEEE"},dayperiod:"a",dayPeriod:"a",hour12:{numeric:"h","2-digit":"hh"},hour24:{numeric:"H","2-digit":"HH"},minute:{numeric:"m","2-digit":"mm"},second:{numeric:"s","2-digit":"ss"},timeZoneName:{long:"ZZZZZ",short:"ZZZ"}};function tokenForPart(e,t,n){const{type:r,value:i}=e;if("literal"===r){const e=/^\s+$/.test(i);return{literal:!e,val:e?" ":i}}const s=t[r];let a=r;"hour"===r&&(a=null!=t.hour12?t.hour12?"hour12":"hour24":null!=t.hourCycle?"h11"===t.hourCycle||"h12"===t.hourCycle?"hour12":"hour24":n.hour12?"hour12":"hour24");let o=partTypeStyleToTokenVal[a];if("object"==typeof o&&(o=o[s]),o)return{literal:!1,val:o}}function buildRegex(e){return[`^${e.map((e=>e.regex)).reduce(((e,t)=>`${e}(${t.source})`),"")}$`,e]}function match(e,t,n){const r=e.match(t);if(r){const e={};let t=1;for(const i in n)if(hasOwnProperty(n,i)){const s=n[i],a=s.groups?s.groups+1:1;!s.literal&&s.token&&(e[s.token.val[0]]=s.deser(r.slice(t,t+a))),t+=a}return[r,e]}return[r,{}]}function dateTimeFromMatches(e){let t,n=null;isUndefined(e.z)||(n=IANAZone.create(e.z)),isUndefined(e.Z)||(n||(n=new FixedOffsetZone(e.Z)),t=e.Z),isUndefined(e.q)||(e.M=3*(e.q-1)+1),isUndefined(e.h)||(e.h<12&&1===e.a?e.h+=12:12===e.h&&0===e.a&&(e.h=0)),0===e.G&&e.y&&(e.y=-e.y),isUndefined(e.u)||(e.S=parseMillis(e.u));return[Object.keys(e).reduce(((t,n)=>{const r=(e=>{switch(e){case"S":return"millisecond";case"s":return"second";case"m":return"minute";case"h":case"H":return"hour";case"d":return"day";case"o":return"ordinal";case"L":case"M":return"month";case"y":return"year";case"E":case"c":return"weekday";case"W":return"weekNumber";case"k":return"weekYear";case"q":return"quarter";default:return null}})(n);return r&&(t[r]=e[n]),t}),{}),n,t]}let dummyDateTimeCache=null;function getDummyDateTime(){return dummyDateTimeCache||(dummyDateTimeCache=DateTime.fromMillis(1555555555555)),dummyDateTimeCache}function maybeExpandMacroToken(e,t){if(e.literal)return e;const n=formatOptsToTokens(Formatter.macroTokenToFormatOpts(e.val),t);return null==n||n.includes(void 0)?e:n}function expandMacroTokens(e,t){return Array.prototype.concat(...e.map((e=>maybeExpandMacroToken(e,t))))}function explainFromTokens(e,t,n){const r=expandMacroTokens(Formatter.parseFormat(n),e),i=r.map((t=>unitForToken(t,e))),s=i.find((e=>e.invalidReason));if(s)return{input:t,tokens:r,invalidReason:s.invalidReason};{const[e,n]=buildRegex(i),s=RegExp(e,"i"),[a,o]=match(t,s,n),[u,l,c]=o?dateTimeFromMatches(o):[null,null,void 0];if(hasOwnProperty(o,"a")&&hasOwnProperty(o,"H"))throw new ConflictingSpecificationError("Can't include meridiem when specifying 24-hour format");return{input:t,tokens:r,regex:s,rawMatches:a,matches:o,result:u,zone:l,specificOffset:c}}}function parseFromTokens(e,t,n){const{result:r,zone:i,specificOffset:s,invalidReason:a}=explainFromTokens(e,t,n);return[r,i,s,a]}function formatOptsToTokens(e,t){if(!e)return null;const n=Formatter.create(t,e).dtFormatter(getDummyDateTime()),r=n.formatToParts(),i=n.resolvedOptions();return r.map((t=>tokenForPart(t,e,i)))}const INVALID="Invalid DateTime",MAX_DATE=864e13;function unsupportedZone(e){return new Invalid("unsupported zone",`the zone "${e.name}" is not supported`)}function possiblyCachedWeekData(e){return null===e.weekData&&(e.weekData=gregorianToWeek(e.c)),e.weekData}function possiblyCachedLocalWeekData(e){return null===e.localWeekData&&(e.localWeekData=gregorianToWeek(e.c,e.loc.getMinDaysInFirstWeek(),e.loc.getStartOfWeek())),e.localWeekData}function clone(e,t){const n={ts:e.ts,zone:e.zone,c:e.c,o:e.o,loc:e.loc,invalid:e.invalid};return new DateTime({...n,...t,old:n})}function fixOffset(e,t,n){let r=e-60*t*1e3;const i=n.offset(r);if(t===i)return[r,t];r-=60*(i-t)*1e3;const s=n.offset(r);return i===s?[r,i]:[e-60*Math.min(i,s)*1e3,Math.max(i,s)]}function tsToObj(e,t){const n=new Date(e+=60*t*1e3);return{year:n.getUTCFullYear(),month:n.getUTCMonth()+1,day:n.getUTCDate(),hour:n.getUTCHours(),minute:n.getUTCMinutes(),second:n.getUTCSeconds(),millisecond:n.getUTCMilliseconds()}}function objToTS(e,t,n){return fixOffset(objToLocalTS(e),t,n)}function adjustTime(e,t){const n=e.o,r=e.c.year+Math.trunc(t.years),i=e.c.month+Math.trunc(t.months)+3*Math.trunc(t.quarters),s={...e.c,year:r,month:i,day:Math.min(e.c.day,daysInMonth(r,i))+Math.trunc(t.days)+7*Math.trunc(t.weeks)},a=Duration.fromObject({years:t.years-Math.trunc(t.years),quarters:t.quarters-Math.trunc(t.quarters),months:t.months-Math.trunc(t.months),weeks:t.weeks-Math.trunc(t.weeks),days:t.days-Math.trunc(t.days),hours:t.hours,minutes:t.minutes,seconds:t.seconds,milliseconds:t.milliseconds}).as("milliseconds"),o=objToLocalTS(s);let[u,l]=fixOffset(o,n,e.zone);return 0!==a&&(u+=a,l=e.zone.offset(u)),{ts:u,o:l}}function parseDataToDateTime(e,t,n,r,i,s){const{setZone:a,zone:o}=n;if(e&&0!==Object.keys(e).length||t){const r=t||o,i=DateTime.fromObject(e,{...n,zone:r,specificOffset:s});return a?i:i.setZone(o)}return DateTime.invalid(new Invalid("unparsable",`the input "${i}" can't be parsed as ${r}`))}function toTechFormat(e,t,n=!0){return e.isValid?Formatter.create(Locale.create("en-US"),{allowZ:n,forceSimple:!0}).formatDateTimeFromString(e,t):null}function toISODate(e,t){const n=e.c.year>9999||e.c.year<0;let r="";return n&&e.c.year>=0&&(r+="+"),r+=padStart(e.c.year,n?6:4),t?(r+="-",r+=padStart(e.c.month),r+="-",r+=padStart(e.c.day)):(r+=padStart(e.c.month),r+=padStart(e.c.day)),r}function toISOTime(e,t,n,r,i,s){let a=padStart(e.c.hour);return t?(a+=":",a+=padStart(e.c.minute),0===e.c.millisecond&&0===e.c.second&&n||(a+=":")):a+=padStart(e.c.minute),0===e.c.millisecond&&0===e.c.second&&n||(a+=padStart(e.c.second),0===e.c.millisecond&&r||(a+=".",a+=padStart(e.c.millisecond,3))),i&&(e.isOffsetFixed&&0===e.offset&&!s?a+="Z":e.o<0?(a+="-",a+=padStart(Math.trunc(-e.o/60)),a+=":",a+=padStart(Math.trunc(-e.o%60))):(a+="+",a+=padStart(Math.trunc(e.o/60)),a+=":",a+=padStart(Math.trunc(e.o%60)))),s&&(a+="["+e.zone.ianaName+"]"),a}const defaultUnitValues={month:1,day:1,hour:0,minute:0,second:0,millisecond:0},defaultWeekUnitValues={weekNumber:1,weekday:1,hour:0,minute:0,second:0,millisecond:0},defaultOrdinalUnitValues={ordinal:1,hour:0,minute:0,second:0,millisecond:0},orderedUnits=["year","month","day","hour","minute","second","millisecond"],orderedWeekUnits=["weekYear","weekNumber","weekday","hour","minute","second","millisecond"],orderedOrdinalUnits=["year","ordinal","hour","minute","second","millisecond"];function normalizeUnit(e){const t={year:"year",years:"year",month:"month",months:"month",day:"day",days:"day",hour:"hour",hours:"hour",minute:"minute",minutes:"minute",quarter:"quarter",quarters:"quarter",second:"second",seconds:"second",millisecond:"millisecond",milliseconds:"millisecond",weekday:"weekday",weekdays:"weekday",weeknumber:"weekNumber",weeksnumber:"weekNumber",weeknumbers:"weekNumber",weekyear:"weekYear",weekyears:"weekYear",ordinal:"ordinal"}[e.toLowerCase()];if(!t)throw new InvalidUnitError(e);return t}function normalizeUnitWithLocalWeeks(e){switch(e.toLowerCase()){case"localweekday":case"localweekdays":return"localWeekday";case"localweeknumber":case"localweeknumbers":return"localWeekNumber";case"localweekyear":case"localweekyears":return"localWeekYear";default:return normalizeUnit(e)}}function quickDT(e,t){const n=normalizeZone(t.zone,Settings.defaultZone),r=Locale.fromObject(t),i=Settings.now();let s,a;if(isUndefined(e.year))s=i;else{for(const t of orderedUnits)isUndefined(e[t])&&(e[t]=defaultUnitValues[t]);const t=hasInvalidGregorianData(e)||hasInvalidTimeData(e);if(t)return DateTime.invalid(t);const r=n.offset(i);[s,a]=objToTS(e,r,n)}return new DateTime({ts:s,zone:n,loc:r,o:a})}function diffRelative(e,t,n){const r=!!isUndefined(n.round)||n.round,i=(e,i)=>{e=roundTo(e,r||n.calendary?0:2,!0);return t.loc.clone(n).relFormatter(n).format(e,i)},s=r=>n.calendary?t.hasSame(e,r)?0:t.startOf(r).diff(e.startOf(r),r).get(r):t.diff(e,r).get(r);if(n.unit)return i(s(n.unit),n.unit);for(const e of n.units){const t=s(e);if(Math.abs(t)>=1)return i(t,e)}return i(e>t?-0:0,n.units[n.units.length-1])}function lastOpts(e){let t,n={};return e.length>0&&"object"==typeof e[e.length-1]?(n=e[e.length-1],t=Array.from(e).slice(0,e.length-1)):t=Array.from(e),[n,t]}class DateTime{constructor(e){const t=e.zone||Settings.defaultZone;let n=e.invalid||(Number.isNaN(e.ts)?new Invalid("invalid input"):null)||(t.isValid?null:unsupportedZone(t));this.ts=isUndefined(e.ts)?Settings.now():e.ts;let r=null,i=null;if(!n){if(e.old&&e.old.ts===this.ts&&e.old.zone.equals(t))[r,i]=[e.old.c,e.old.o];else{const e=t.offset(this.ts);r=tsToObj(this.ts,e),n=Number.isNaN(r.year)?new Invalid("invalid input"):null,r=n?null:r,i=n?null:e}}this._zone=t,this.loc=e.loc||Locale.create(),this.invalid=n,this.weekData=null,this.localWeekData=null,this.c=r,this.o=i,this.isLuxonDateTime=!0}static now(){return new DateTime({})}static local(){const[e,t]=lastOpts(arguments),[n,r,i,s,a,o,u]=t;return quickDT({year:n,month:r,day:i,hour:s,minute:a,second:o,millisecond:u},e)}static utc(){const[e,t]=lastOpts(arguments),[n,r,i,s,a,o,u]=t;return e.zone=FixedOffsetZone.utcInstance,quickDT({year:n,month:r,day:i,hour:s,minute:a,second:o,millisecond:u},e)}static fromJSDate(e,t={}){const n=isDate(e)?e.valueOf():NaN;if(Number.isNaN(n))return DateTime.invalid("invalid input");const r=normalizeZone(t.zone,Settings.defaultZone);return r.isValid?new DateTime({ts:n,zone:r,loc:Locale.fromObject(t)}):DateTime.invalid(unsupportedZone(r))}static fromMillis(e,t={}){if(isNumber(e))return e<-MAX_DATE||e>MAX_DATE?DateTime.invalid("Timestamp out of range"):new DateTime({ts:e,zone:normalizeZone(t.zone,Settings.defaultZone),loc:Locale.fromObject(t)});throw new InvalidArgumentError(`fromMillis requires a numerical input, but received a ${typeof e} with value ${e}`)}static fromSeconds(e,t={}){if(isNumber(e))return new DateTime({ts:1e3*e,zone:normalizeZone(t.zone,Settings.defaultZone),loc:Locale.fromObject(t)});throw new InvalidArgumentError("fromSeconds requires a numerical input")}static fromObject(e,t={}){e=e||{};const n=normalizeZone(t.zone,Settings.defaultZone);if(!n.isValid)return DateTime.invalid(unsupportedZone(n));const r=Locale.fromObject(t),i=normalizeObject(e,normalizeUnitWithLocalWeeks),{minDaysInFirstWeek:s,startOfWeek:a}=usesLocalWeekValues(i,r),o=Settings.now(),u=isUndefined(t.specificOffset)?n.offset(o):t.specificOffset,l=!isUndefined(i.ordinal),c=!isUndefined(i.year),d=!isUndefined(i.month)||!isUndefined(i.day),m=c||d,h=i.weekYear||i.weekNumber;if((m||l)&&h)throw new ConflictingSpecificationError("Can't mix weekYear/weekNumber units with year/month/day or ordinals");if(d&&l)throw new ConflictingSpecificationError("Can't mix ordinal dates with month/day");const f=h||i.weekday&&!m;let y,g,T=tsToObj(o,u);f?(y=orderedWeekUnits,g=defaultWeekUnitValues,T=gregorianToWeek(T,s,a)):l?(y=orderedOrdinalUnits,g=defaultOrdinalUnitValues,T=gregorianToOrdinal(T)):(y=orderedUnits,g=defaultUnitValues);let p=!1;for(const e of y){isUndefined(i[e])?i[e]=p?g[e]:T[e]:p=!0}const O=(f?hasInvalidWeekData(i,s,a):l?hasInvalidOrdinalData(i):hasInvalidGregorianData(i))||hasInvalidTimeData(i);if(O)return DateTime.invalid(O);const S=f?weekToGregorian(i,s,a):l?ordinalToGregorian(i):i,[I,D]=objToTS(S,u,n),w=new DateTime({ts:I,zone:n,o:D,loc:r});return i.weekday&&m&&e.weekday!==w.weekday?DateTime.invalid("mismatched weekday",`you can't specify both a weekday of ${i.weekday} and a date of ${w.toISO()}`):w}static fromISO(e,t={}){const[n,r]=parseISODate(e);return parseDataToDateTime(n,r,t,"ISO 8601",e)}static fromRFC2822(e,t={}){const[n,r]=parseRFC2822Date(e);return parseDataToDateTime(n,r,t,"RFC 2822",e)}static fromHTTP(e,t={}){const[n,r]=parseHTTPDate(e);return parseDataToDateTime(n,r,t,"HTTP",t)}static fromFormat(e,t,n={}){if(isUndefined(e)||isUndefined(t))throw new InvalidArgumentError("fromFormat requires an input string and a format");const{locale:r=null,numberingSystem:i=null}=n,s=Locale.fromOpts({locale:r,numberingSystem:i,defaultToEN:!0}),[a,o,u,l]=parseFromTokens(s,e,t);return l?DateTime.invalid(l):parseDataToDateTime(a,o,n,`format ${t}`,e,u)}static fromString(e,t,n={}){return DateTime.fromFormat(e,t,n)}static fromSQL(e,t={}){const[n,r]=parseSQL(e);return parseDataToDateTime(n,r,t,"SQL",e)}static invalid(e,t=null){if(!e)throw new InvalidArgumentError("need to specify a reason the DateTime is invalid");const n=e instanceof Invalid?e:new Invalid(e,t);if(Settings.throwOnInvalid)throw new InvalidDateTimeError(n);return new DateTime({invalid:n})}static isDateTime(e){return e&&e.isLuxonDateTime||!1}static parseFormatForOpts(e,t={}){const n=formatOptsToTokens(e,Locale.fromObject(t));return n?n.map((e=>e?e.val:null)).join(""):null}static expandFormat(e,t={}){return expandMacroTokens(Formatter.parseFormat(e),Locale.fromObject(t)).map((e=>e.val)).join("")}get(e){return this[e]}get isValid(){return null===this.invalid}get invalidReason(){return this.invalid?this.invalid.reason:null}get invalidExplanation(){return this.invalid?this.invalid.explanation:null}get locale(){return this.isValid?this.loc.locale:null}get numberingSystem(){return this.isValid?this.loc.numberingSystem:null}get outputCalendar(){return this.isValid?this.loc.outputCalendar:null}get zone(){return this._zone}get zoneName(){return this.isValid?this.zone.name:null}get year(){return this.isValid?this.c.year:NaN}get quarter(){return this.isValid?Math.ceil(this.c.month/3):NaN}get month(){return this.isValid?this.c.month:NaN}get day(){return this.isValid?this.c.day:NaN}get hour(){return this.isValid?this.c.hour:NaN}get minute(){return this.isValid?this.c.minute:NaN}get second(){return this.isValid?this.c.second:NaN}get millisecond(){return this.isValid?this.c.millisecond:NaN}get weekYear(){return this.isValid?possiblyCachedWeekData(this).weekYear:NaN}get weekNumber(){return this.isValid?possiblyCachedWeekData(this).weekNumber:NaN}get weekday(){return this.isValid?possiblyCachedWeekData(this).weekday:NaN}get isWeekend(){return this.isValid&&this.loc.getWeekendDays().includes(this.weekday)}get localWeekday(){return this.isValid?possiblyCachedLocalWeekData(this).weekday:NaN}get localWeekNumber(){return this.isValid?possiblyCachedLocalWeekData(this).weekNumber:NaN}get localWeekYear(){return this.isValid?possiblyCachedLocalWeekData(this).weekYear:NaN}get ordinal(){return this.isValid?gregorianToOrdinal(this.c).ordinal:NaN}get monthShort(){return this.isValid?Info.months("short",{locObj:this.loc})[this.month-1]:null}get monthLong(){return this.isValid?Info.months("long",{locObj:this.loc})[this.month-1]:null}get weekdayShort(){return this.isValid?Info.weekdays("short",{locObj:this.loc})[this.weekday-1]:null}get weekdayLong(){return this.isValid?Info.weekdays("long",{locObj:this.loc})[this.weekday-1]:null}get offset(){return this.isValid?+this.o:NaN}get offsetNameShort(){return this.isValid?this.zone.offsetName(this.ts,{format:"short",locale:this.locale}):null}get offsetNameLong(){return this.isValid?this.zone.offsetName(this.ts,{format:"long",locale:this.locale}):null}get isOffsetFixed(){return this.isValid?this.zone.isUniversal:null}get isInDST(){return!this.isOffsetFixed&&(this.offset>this.set({month:1,day:1}).offset||this.offset>this.set({month:5}).offset)}getPossibleOffsets(){if(!this.isValid||this.isOffsetFixed)return[this];const e=864e5,t=6e4,n=objToLocalTS(this.c),r=this.zone.offset(n-e),i=this.zone.offset(n+e),s=this.zone.offset(n-r*t),a=this.zone.offset(n-i*t);if(s===a)return[this];const o=n-s*t,u=n-a*t,l=tsToObj(o,s),c=tsToObj(u,a);return l.hour===c.hour&&l.minute===c.minute&&l.second===c.second&&l.millisecond===c.millisecond?[clone(this,{ts:o}),clone(this,{ts:u})]:[this]}get isInLeapYear(){return isLeapYear(this.year)}get daysInMonth(){return daysInMonth(this.year,this.month)}get daysInYear(){return this.isValid?daysInYear(this.year):NaN}get weeksInWeekYear(){return this.isValid?weeksInWeekYear(this.weekYear):NaN}get weeksInLocalWeekYear(){return this.isValid?weeksInWeekYear(this.localWeekYear,this.loc.getMinDaysInFirstWeek(),this.loc.getStartOfWeek()):NaN}resolvedLocaleOptions(e={}){const{locale:t,numberingSystem:n,calendar:r}=Formatter.create(this.loc.clone(e),e).resolvedOptions(this);return{locale:t,numberingSystem:n,outputCalendar:r}}toUTC(e=0,t={}){return this.setZone(FixedOffsetZone.instance(e),t)}toLocal(){return this.setZone(Settings.defaultZone)}setZone(e,{keepLocalTime:t=!1,keepCalendarTime:n=!1}={}){if((e=normalizeZone(e,Settings.defaultZone)).equals(this.zone))return this;if(e.isValid){let r=this.ts;if(t||n){const t=e.offset(this.ts),n=this.toObject();[r]=objToTS(n,t,e)}return clone(this,{ts:r,zone:e})}return DateTime.invalid(unsupportedZone(e))}reconfigure({locale:e,numberingSystem:t,outputCalendar:n}={}){return clone(this,{loc:this.loc.clone({locale:e,numberingSystem:t,outputCalendar:n})})}setLocale(e){return this.reconfigure({locale:e})}set(e){if(!this.isValid)return this;const t=normalizeObject(e,normalizeUnitWithLocalWeeks),{minDaysInFirstWeek:n,startOfWeek:r}=usesLocalWeekValues(t,this.loc),i=!isUndefined(t.weekYear)||!isUndefined(t.weekNumber)||!isUndefined(t.weekday),s=!isUndefined(t.ordinal),a=!isUndefined(t.year),o=!isUndefined(t.month)||!isUndefined(t.day),u=a||o,l=t.weekYear||t.weekNumber;if((u||s)&&l)throw new ConflictingSpecificationError("Can't mix weekYear/weekNumber units with year/month/day or ordinals");if(o&&s)throw new ConflictingSpecificationError("Can't mix ordinal dates with month/day");let c;i?c=weekToGregorian({...gregorianToWeek(this.c,n,r),...t},n,r):isUndefined(t.ordinal)?(c={...this.toObject(),...t},isUndefined(t.day)&&(c.day=Math.min(daysInMonth(c.year,c.month),c.day))):c=ordinalToGregorian({...gregorianToOrdinal(this.c),...t});const[d,m]=objToTS(c,this.o,this.zone);return clone(this,{ts:d,o:m})}plus(e){if(!this.isValid)return this;return clone(this,adjustTime(this,Duration.fromDurationLike(e)))}minus(e){if(!this.isValid)return this;return clone(this,adjustTime(this,Duration.fromDurationLike(e).negate()))}startOf(e,{useLocaleWeeks:t=!1}={}){if(!this.isValid)return this;const n={},r=Duration.normalizeUnit(e);switch(r){case"years":n.month=1;case"quarters":case"months":n.day=1;case"weeks":case"days":n.hour=0;case"hours":n.minute=0;case"minutes":n.second=0;case"seconds":n.millisecond=0}if("weeks"===r)if(t){const e=this.loc.getStartOfWeek(),{weekday:t}=this;t<e&&(n.weekNumber=this.weekNumber-1),n.weekday=e}else n.weekday=1;if("quarters"===r){const e=Math.ceil(this.month/3);n.month=3*(e-1)+1}return this.set(n)}endOf(e,t){return this.isValid?this.plus({[e]:1}).startOf(e,t).minus(1):this}toFormat(e,t={}){return this.isValid?Formatter.create(this.loc.redefaultToEN(t)).formatDateTimeFromString(this,e):INVALID}toLocaleString(e=DATE_SHORT,t={}){return this.isValid?Formatter.create(this.loc.clone(t),e).formatDateTime(this):INVALID}toLocaleParts(e={}){return this.isValid?Formatter.create(this.loc.clone(e),e).formatDateTimeParts(this):[]}toISO({format:e="extended",suppressSeconds:t=!1,suppressMilliseconds:n=!1,includeOffset:r=!0,extendedZone:i=!1}={}){if(!this.isValid)return null;const s="extended"===e;let a=toISODate(this,s);return a+="T",a+=toISOTime(this,s,t,n,r,i),a}toISODate({format:e="extended"}={}){return this.isValid?toISODate(this,"extended"===e):null}toISOWeekDate(){return toTechFormat(this,"kkkk-'W'WW-c")}toISOTime({suppressMilliseconds:e=!1,suppressSeconds:t=!1,includeOffset:n=!0,includePrefix:r=!1,extendedZone:i=!1,format:s="extended"}={}){if(!this.isValid)return null;return(r?"T":"")+toISOTime(this,"extended"===s,t,e,n,i)}toRFC2822(){return toTechFormat(this,"EEE, dd LLL yyyy HH:mm:ss ZZZ",!1)}toHTTP(){return toTechFormat(this.toUTC(),"EEE, dd LLL yyyy HH:mm:ss 'GMT'")}toSQLDate(){return this.isValid?toISODate(this,!0):null}toSQLTime({includeOffset:e=!0,includeZone:t=!1,includeOffsetSpace:n=!0}={}){let r="HH:mm:ss.SSS";return(t||e)&&(n&&(r+=" "),t?r+="z":e&&(r+="ZZ")),toTechFormat(this,r,!0)}toSQL(e={}){return this.isValid?`${this.toSQLDate()} ${this.toSQLTime(e)}`:null}toString(){return this.isValid?this.toISO():INVALID}[Symbol.for("nodejs.util.inspect.custom")](){return this.isValid?`DateTime { ts: ${this.toISO()}, zone: ${this.zone.name}, locale: ${this.locale} }`:`DateTime { Invalid, reason: ${this.invalidReason} }`}valueOf(){return this.toMillis()}toMillis(){return this.isValid?this.ts:NaN}toSeconds(){return this.isValid?this.ts/1e3:NaN}toUnixInteger(){return this.isValid?Math.floor(this.ts/1e3):NaN}toJSON(){return this.toISO()}toBSON(){return this.toJSDate()}toObject(e={}){if(!this.isValid)return{};const t={...this.c};return e.includeConfig&&(t.outputCalendar=this.outputCalendar,t.numberingSystem=this.loc.numberingSystem,t.locale=this.loc.locale),t}toJSDate(){return new Date(this.isValid?this.ts:NaN)}diff(e,t="milliseconds",n={}){if(!this.isValid||!e.isValid)return Duration.invalid("created by diffing an invalid DateTime");const r={locale:this.locale,numberingSystem:this.numberingSystem,...n},i=maybeArray(t).map(Duration.normalizeUnit),s=e.valueOf()>this.valueOf(),a=diff(s?this:e,s?e:this,i,r);return s?a.negate():a}diffNow(e="milliseconds",t={}){return this.diff(DateTime.now(),e,t)}until(e){return this.isValid?Interval.fromDateTimes(this,e):this}hasSame(e,t,n){if(!this.isValid)return!1;const r=e.valueOf(),i=this.setZone(e.zone,{keepLocalTime:!0});return i.startOf(t,n)<=r&&r<=i.endOf(t,n)}equals(e){return this.isValid&&e.isValid&&this.valueOf()===e.valueOf()&&this.zone.equals(e.zone)&&this.loc.equals(e.loc)}toRelative(e={}){if(!this.isValid)return null;const t=e.base||DateTime.fromObject({},{zone:this.zone}),n=e.padding?this<t?-e.padding:e.padding:0;let r=["years","months","days","hours","minutes","seconds"],i=e.unit;return Array.isArray(e.unit)&&(r=e.unit,i=void 0),diffRelative(t,this.plus(n),{...e,numeric:"always",units:r,unit:i})}toRelativeCalendar(e={}){return this.isValid?diffRelative(e.base||DateTime.fromObject({},{zone:this.zone}),this,{...e,numeric:"auto",units:["years","months","days"],calendary:!0}):null}static min(...e){if(!e.every(DateTime.isDateTime))throw new InvalidArgumentError("min requires all arguments be DateTimes");return bestBy(e,(e=>e.valueOf()),Math.min)}static max(...e){if(!e.every(DateTime.isDateTime))throw new InvalidArgumentError("max requires all arguments be DateTimes");return bestBy(e,(e=>e.valueOf()),Math.max)}static fromFormatExplain(e,t,n={}){const{locale:r=null,numberingSystem:i=null}=n;return explainFromTokens(Locale.fromOpts({locale:r,numberingSystem:i,defaultToEN:!0}),e,t)}static fromStringExplain(e,t,n={}){return DateTime.fromFormatExplain(e,t,n)}static get DATE_SHORT(){return DATE_SHORT}static get DATE_MED(){return DATE_MED}static get DATE_MED_WITH_WEEKDAY(){return DATE_MED_WITH_WEEKDAY}static get DATE_FULL(){return DATE_FULL}static get DATE_HUGE(){return DATE_HUGE}static get TIME_SIMPLE(){return TIME_SIMPLE}static get TIME_WITH_SECONDS(){return TIME_WITH_SECONDS}static get TIME_WITH_SHORT_OFFSET(){return TIME_WITH_SHORT_OFFSET}static get TIME_WITH_LONG_OFFSET(){return TIME_WITH_LONG_OFFSET}static get TIME_24_SIMPLE(){return TIME_24_SIMPLE}static get TIME_24_WITH_SECONDS(){return TIME_24_WITH_SECONDS}static get TIME_24_WITH_SHORT_OFFSET(){return TIME_24_WITH_SHORT_OFFSET}static get TIME_24_WITH_LONG_OFFSET(){return TIME_24_WITH_LONG_OFFSET}static get DATETIME_SHORT(){return DATETIME_SHORT}static get DATETIME_SHORT_WITH_SECONDS(){return DATETIME_SHORT_WITH_SECONDS}static get DATETIME_MED(){return DATETIME_MED}static get DATETIME_MED_WITH_SECONDS(){return DATETIME_MED_WITH_SECONDS}static get DATETIME_MED_WITH_WEEKDAY(){return DATETIME_MED_WITH_WEEKDAY}static get DATETIME_FULL(){return DATETIME_FULL}static get DATETIME_FULL_WITH_SECONDS(){return DATETIME_FULL_WITH_SECONDS}static get DATETIME_HUGE(){return DATETIME_HUGE}static get DATETIME_HUGE_WITH_SECONDS(){return DATETIME_HUGE_WITH_SECONDS}}function friendlyDateTime(e){if(DateTime.isDateTime(e))return e;if(e&&e.valueOf&&isNumber(e.valueOf()))return DateTime.fromJSDate(e);if(e&&"object"==typeof e)return DateTime.fromObject(e);throw new InvalidArgumentError(`Unknown datetime argument: ${e}, of type ${typeof e}`)}const VERSION="3.4.4";export{DateTime,Duration,FixedOffsetZone,IANAZone,Info,Interval,InvalidZone,Settings,SystemZone,VERSION,Zone};