/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import flatpickr from"flatpickr/flatpickr.min.js";import ShortcutButtonsPlugin from"flatpickr/plugins/shortcut-buttons.min.js";import{DateTime}from"luxon";import ThrottleEvent from"@typo3/core/event/throttle-event.js";class DateTimePicker{constructor(){this.format=(void 0!==opener?.top?.TYPO3?opener.top:top).TYPO3.settings.DateTimePicker.DateFormat}static formatDateForHiddenField(e,t){return"time"!==t&&"timesec"!==t||(e=e.set({year:1970,month:1,day:1})),e.toISO({suppressMilliseconds:!0})}initialize(e){if(!(e instanceof HTMLInputElement)||void 0!==e.dataset.datepickerInitialized)return;let t=document.documentElement.lang;t&&"en"!==t?"ch"===t&&(t="zh"):t="default",e.dataset.datepickerInitialized="1",import("flatpickr/locales.js").then((()=>{this.initializeField(e,t)}))}initializeField(e,t){const a=this.getScrollEvent(),n=this.getDateOptions(e);n.locale=t,n.onOpen=[()=>{a.bindTo(document.querySelector(".t3js-module-body"))}],n.onClose=()=>{a.release()};const o=flatpickr(e,n);e.addEventListener("input",(()=>{const e=o._input.value,t=o.parseDate(e);e===o.formatDate(t,o.config.dateFormat)&&o.setDate(e)})),e.addEventListener("keyup",(e=>{"Escape"===e.key&&o.close()})),e.addEventListener("change",(t=>{t.stopImmediatePropagation();const a=t.target,n=e.parentElement.parentElement.querySelector('input[type="hidden"]');if(""!==a.value){const e=a.dataset.dateType,t=DateTime.fromFormat(a.value,a._flatpickr.config.dateFormat,{zone:"utc"});t.isValid?n.value=DateTimePicker.formatDateForHiddenField(t,e):a.value=DateTimePicker.formatDateForHiddenField(DateTime.fromISO(n.value,{zone:"utc"}),e)}else n.value="";a.dispatchEvent(new Event("formengine.dp.change"))}))}getScrollEvent(){return new ThrottleEvent("scroll",(()=>{const e=document.querySelector(".flatpickr-input.active");if(null===e)return;const t=e.getBoundingClientRect(),a=e._flatpickr.calendarContainer.offsetHeight;let n,o;window.innerHeight-t.bottom<a&&t.top>a?(n=t.y-a-2,o="arrowBottom"):(n=t.y+t.height+2,o="arrowTop"),e._flatpickr.calendarContainer.style.top=n+"px",e._flatpickr.calendarContainer.classList.remove("arrowBottom","arrowTop"),e._flatpickr.calendarContainer.classList.add(o)}),15)}getDateOptions(e){const t=this.format,a=e.dataset.dateType,n=new Date,o={allowInput:!0,dateFormat:"",defaultDate:e.value,defaultHour:n.getHours(),defaultMinute:n.getMinutes(),enableSeconds:!1,enableTime:!1,formatDate:(e,t)=>DateTime.fromJSDate(e).toFormat(t),parseDate:(e,t)=>DateTime.fromFormat(e,t).toJSDate(),maxDate:"",minDate:"",minuteIncrement:1,noCalendar:!1,weekNumbers:!0,time_24hr:!Intl.DateTimeFormat(navigator.language,{hour:"numeric"}).resolvedOptions().hour12,plugins:[ShortcutButtonsPlugin({theme:"typo3",button:[{label:top.TYPO3.lang["labels.datepicker.today"]||"Today"}],onClick:(e,t)=>{t.setDate(new Date,!0)}})]};switch(a){case"datetime":o.dateFormat=t[1],o.enableTime=!0;break;case"date":o.dateFormat=t[0];break;case"time":o.dateFormat="HH:mm",o.enableTime=!0,o.noCalendar=!0;break;case"timesec":o.dateFormat="HH:mm:ss",o.enableSeconds=!0,o.enableTime=!0,o.noCalendar=!0;break;case"year":o.dateFormat="yyyy"}return"undefined"!==e.dataset.dateMindate&&(o.minDate=e.dataset.dateMindate),"undefined"!==e.dataset.dateMaxdate&&(o.maxDate=e.dataset.dateMaxdate),o}}export default new DateTimePicker;